// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  CurveScriptingPluginInfo.C
// ************************************************************************* //
#include <PyCurveAttributes.h>
#include <CurvePluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Curve,Scripting)

// ****************************************************************************
// Method: CurveScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CurveScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyCurveAttributes_StartUp((CurveAttributes *)subj, data);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
CurveScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCurveAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Curve plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CurveScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCurveAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
CurveScriptingPluginInfo::GetLogString()
{
    std::string s(PyCurveAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CurveScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCurveAttributes_SetDefaults((const CurveAttributes *)atts);
}
