// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CurveCommonPluginInfo.C
// ****************************************************************************

#include <CurvePluginInfo.h>
#include <CurveAttributes.h>

// ****************************************************************************
//  Method: CurveCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CurveCommonPluginInfo::AllocAttributes()
{
    return new CurveAttributes;
}

// ****************************************************************************
//  Method: CurveCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Curve attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CurveCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((CurveAttributes *) to) = *((CurveAttributes *) from);
}

// ****************************************************************************
// Method: CurveCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
CurveCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_CURVE;
}

