// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ContourGUIPluginInfo.C
// ****************************************************************************

#include <ContourPluginInfo.h>
#include <ContourAttributes.h>
#include <QApplication>
#include <QvisContourPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Contour,GUI)

// ****************************************************************************
//  Method: ContourGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ContourGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Contour"));
}


// ****************************************************************************
//  Method: ContourGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ContourGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisContourPlotWindow(type, (ContourAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: ContourGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Contour.xpm>
const char **
ContourGUIPluginInfo::XPMIconData() const
{
    return Contour_xpm;
}

