// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoundaryPluginInfo.C
// ****************************************************************************

#include <BoundaryPluginInfo.h>
#include <BoundaryAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Boundary,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Boundary,General)

// ****************************************************************************
//  Method: BoundaryGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryGeneralPluginInfo::GetName() const
{
    return "Boundary";
}

// ****************************************************************************
//  Method: BoundaryGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: BoundaryGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryGeneralPluginInfo::GetID() const
{
    return "Boundary_1.0";
}
// ****************************************************************************
//  Method: BoundaryGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
BoundaryGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
