// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoundaryCommonPluginInfo.C
// ****************************************************************************

#include <BoundaryPluginInfo.h>
#include <BoundaryAttributes.h>

// ****************************************************************************
//  Method: BoundaryCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
BoundaryCommonPluginInfo::AllocAttributes()
{
    return new BoundaryAttributes;
}

// ****************************************************************************
//  Method: BoundaryCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Boundary attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoundaryCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((BoundaryAttributes *) to) = *((BoundaryAttributes *) from);
}

// ****************************************************************************
// Method: BoundaryCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
BoundaryCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MATERIAL;
}

