// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <BoundaryAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for BoundaryAttributes::ColoringMethod
//

static const char *ColoringMethod_strings[] = {
"ColorBySingleColor", "ColorByMultipleColors", "ColorByColorTable"
};

std::string
BoundaryAttributes::ColoringMethod_ToString(BoundaryAttributes::ColoringMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ColoringMethod_strings[index];
}

std::string
BoundaryAttributes::ColoringMethod_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ColoringMethod_strings[index];
}

bool
BoundaryAttributes::ColoringMethod_FromString(const std::string &s, BoundaryAttributes::ColoringMethod &val)
{
    val = BoundaryAttributes::ColorBySingleColor;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ColoringMethod_strings[i])
        {
            val = (ColoringMethod)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: BoundaryAttributes::BoundaryAttributes
//
// Purpose:
//   Init utility for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void BoundaryAttributes::Init()
{
    colorType = ColorByMultipleColors;
    invertColorTable = false;
    legendFlag = true;
    lineWidth = 0;
    opacity = 1;
    wireframe = false;
    smoothingLevel = 0;

    BoundaryAttributes::SelectAll();
}

// ****************************************************************************
// Method: BoundaryAttributes::BoundaryAttributes
//
// Purpose:
//   Copy utility for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void BoundaryAttributes::Copy(const BoundaryAttributes &obj)
{
    colorType = obj.colorType;
    colorTableName = obj.colorTableName;
    invertColorTable = obj.invertColorTable;
    legendFlag = obj.legendFlag;
    lineWidth = obj.lineWidth;
    singleColor = obj.singleColor;
    multiColor = obj.multiColor;
    boundaryNames = obj.boundaryNames;
    opacity = obj.opacity;
    wireframe = obj.wireframe;
    smoothingLevel = obj.smoothingLevel;

    BoundaryAttributes::SelectAll();
}

// Type map format string
const char *BoundaryAttributes::TypeMapFormatString = BOUNDARYATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t BoundaryAttributes::TmfsStruct = {BOUNDARYATTRIBUTES_TMFS};


// ****************************************************************************
// Method: BoundaryAttributes::BoundaryAttributes
//
// Purpose:
//   Default constructor for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryAttributes::BoundaryAttributes() :
    AttributeSubject(BoundaryAttributes::TypeMapFormatString),
    colorTableName("Default"), singleColor()
{
    BoundaryAttributes::Init();
}

// ****************************************************************************
// Method: BoundaryAttributes::BoundaryAttributes
//
// Purpose:
//   Constructor for the derived classes of BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryAttributes::BoundaryAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    colorTableName("Default"), singleColor()
{
    BoundaryAttributes::Init();
}

// ****************************************************************************
// Method: BoundaryAttributes::BoundaryAttributes
//
// Purpose:
//   Copy constructor for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryAttributes::BoundaryAttributes(const BoundaryAttributes &obj) :
    AttributeSubject(BoundaryAttributes::TypeMapFormatString)
{
    BoundaryAttributes::Copy(obj);
}

// ****************************************************************************
// Method: BoundaryAttributes::BoundaryAttributes
//
// Purpose:
//   Copy constructor for derived classes of the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryAttributes::BoundaryAttributes(const BoundaryAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    BoundaryAttributes::Copy(obj);
}

// ****************************************************************************
// Method: BoundaryAttributes::~BoundaryAttributes
//
// Purpose:
//   Destructor for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryAttributes::~BoundaryAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: BoundaryAttributes::operator =
//
// Purpose:
//   Assignment operator for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryAttributes&
BoundaryAttributes::operator = (const BoundaryAttributes &obj)
{
    if (this == &obj) return *this;

    BoundaryAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: BoundaryAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryAttributes::operator == (const BoundaryAttributes &obj) const
{
    // Create the return value
    return ((colorType == obj.colorType) &&
            (colorTableName == obj.colorTableName) &&
            (invertColorTable == obj.invertColorTable) &&
            (legendFlag == obj.legendFlag) &&
            (lineWidth == obj.lineWidth) &&
            (singleColor == obj.singleColor) &&
            (multiColor == obj.multiColor) &&
            (boundaryNames == obj.boundaryNames) &&
            (opacity == obj.opacity) &&
            (wireframe == obj.wireframe) &&
            (smoothingLevel == obj.smoothingLevel));
}

// ****************************************************************************
// Method: BoundaryAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryAttributes::operator != (const BoundaryAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: BoundaryAttributes::TypeName
//
// Purpose:
//   Type name method for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
BoundaryAttributes::TypeName() const
{
    return "BoundaryAttributes";
}

// ****************************************************************************
// Method: BoundaryAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const BoundaryAttributes *tmp = (const BoundaryAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: BoundaryAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
BoundaryAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new BoundaryAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: BoundaryAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the BoundaryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
BoundaryAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new BoundaryAttributes(*this);
    else
        retval = new BoundaryAttributes;

    return retval;
}

// ****************************************************************************
// Method: BoundaryAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryAttributes::SelectAll()
{
    Select(ID_colorType,        (void *)&colorType);
    Select(ID_colorTableName,   (void *)&colorTableName);
    Select(ID_invertColorTable, (void *)&invertColorTable);
    Select(ID_legendFlag,       (void *)&legendFlag);
    Select(ID_lineWidth,        (void *)&lineWidth);
    Select(ID_singleColor,      (void *)&singleColor);
    Select(ID_multiColor,       (void *)&multiColor);
    Select(ID_boundaryNames,    (void *)&boundaryNames);
    Select(ID_opacity,          (void *)&opacity);
    Select(ID_wireframe,        (void *)&wireframe);
    Select(ID_smoothingLevel,   (void *)&smoothingLevel);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoundaryAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    BoundaryAttributes defaultObject;
    bool addToParent = false;
    // Create a node for BoundaryAttributes.
    DataNode *node = new DataNode("BoundaryAttributes");

    if(completeSave || !FieldsEqual(ID_colorType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorType", ColoringMethod_ToString(colorType)));
    }

    if(completeSave || !FieldsEqual(ID_colorTableName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

    if(completeSave || !FieldsEqual(ID_invertColorTable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("invertColorTable", invertColorTable));
    }

    if(completeSave || !FieldsEqual(ID_legendFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *singleColorNode = new DataNode("singleColor");
        if(singleColor.CreateNode(singleColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(singleColorNode);
        }
        else
            delete singleColorNode;
    if(completeSave || !FieldsEqual(ID_multiColor, &defaultObject))
    {
        DataNode *multiColorNode = new DataNode("multiColor");
        if(multiColor.CreateNode(multiColorNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(multiColorNode);
        }
        else
            delete multiColorNode;
    }

    if(completeSave || !FieldsEqual(ID_boundaryNames, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("boundaryNames", boundaryNames));
    }

    if(completeSave || !FieldsEqual(ID_opacity, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("opacity", opacity));
    }

    if(completeSave || !FieldsEqual(ID_wireframe, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wireframe", wireframe));
    }

    if(completeSave || !FieldsEqual(ID_smoothingLevel, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothingLevel", smoothingLevel));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: BoundaryAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("BoundaryAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("colorType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetColorType(ColoringMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ColoringMethod value;
            if(ColoringMethod_FromString(node->AsString(), value))
                SetColorType(value);
        }
    }
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("invertColorTable")) != 0)
        SetInvertColorTable(node->AsBool());
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("singleColor")) != 0)
        singleColor.SetFromNode(node);
    if((node = searchNode->GetNode("multiColor")) != 0)
        multiColor.SetFromNode(node);
    if((node = searchNode->GetNode("boundaryNames")) != 0)
        SetBoundaryNames(node->AsStringVector());
    if((node = searchNode->GetNode("opacity")) != 0)
        SetOpacity(node->AsDouble());
    if((node = searchNode->GetNode("wireframe")) != 0)
        SetWireframe(node->AsBool());
    if((node = searchNode->GetNode("smoothingLevel")) != 0)
        SetSmoothingLevel(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
BoundaryAttributes::SetColorType(BoundaryAttributes::ColoringMethod colorType_)
{
    colorType = colorType_;
    Select(ID_colorType, (void *)&colorType);
}

void
BoundaryAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(ID_colorTableName, (void *)&colorTableName);
}

void
BoundaryAttributes::SetInvertColorTable(bool invertColorTable_)
{
    invertColorTable = invertColorTable_;
    Select(ID_invertColorTable, (void *)&invertColorTable);
}

void
BoundaryAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(ID_legendFlag, (void *)&legendFlag);
}

void
BoundaryAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
BoundaryAttributes::SetSingleColor(const ColorAttribute &singleColor_)
{
    singleColor = singleColor_;
    Select(ID_singleColor, (void *)&singleColor);
}

void
BoundaryAttributes::SetMultiColor(const ColorAttributeList &multiColor_)
{
    multiColor = multiColor_;
    Select(ID_multiColor, (void *)&multiColor);
}

void
BoundaryAttributes::SetBoundaryNames(const stringVector &boundaryNames_)
{
    boundaryNames = boundaryNames_;
    Select(ID_boundaryNames, (void *)&boundaryNames);
}

void
BoundaryAttributes::SetOpacity(double opacity_)
{
    opacity = opacity_;
    Select(ID_opacity, (void *)&opacity);
}

void
BoundaryAttributes::SetWireframe(bool wireframe_)
{
    wireframe = wireframe_;
    Select(ID_wireframe, (void *)&wireframe);
}

void
BoundaryAttributes::SetSmoothingLevel(int smoothingLevel_)
{
    smoothingLevel = smoothingLevel_;
    Select(ID_smoothingLevel, (void *)&smoothingLevel);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

BoundaryAttributes::ColoringMethod
BoundaryAttributes::GetColorType() const
{
    return ColoringMethod(colorType);
}

const std::string &
BoundaryAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
BoundaryAttributes::GetColorTableName()
{
    return colorTableName;
}

bool
BoundaryAttributes::GetInvertColorTable() const
{
    return invertColorTable;
}

bool
BoundaryAttributes::GetLegendFlag() const
{
    return legendFlag;
}

int
BoundaryAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
BoundaryAttributes::GetSingleColor() const
{
    return singleColor;
}

ColorAttribute &
BoundaryAttributes::GetSingleColor()
{
    return singleColor;
}

const ColorAttributeList &
BoundaryAttributes::GetMultiColor() const
{
    return multiColor;
}

ColorAttributeList &
BoundaryAttributes::GetMultiColor()
{
    return multiColor;
}

const stringVector &
BoundaryAttributes::GetBoundaryNames() const
{
    return boundaryNames;
}

stringVector &
BoundaryAttributes::GetBoundaryNames()
{
    return boundaryNames;
}

double
BoundaryAttributes::GetOpacity() const
{
    return opacity;
}

bool
BoundaryAttributes::GetWireframe() const
{
    return wireframe;
}

int
BoundaryAttributes::GetSmoothingLevel() const
{
    return smoothingLevel;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
BoundaryAttributes::SelectColorTableName()
{
    Select(ID_colorTableName, (void *)&colorTableName);
}

void
BoundaryAttributes::SelectSingleColor()
{
    Select(ID_singleColor, (void *)&singleColor);
}

void
BoundaryAttributes::SelectMultiColor()
{
    Select(ID_multiColor, (void *)&multiColor);
}

void
BoundaryAttributes::SelectBoundaryNames()
{
    Select(ID_boundaryNames, (void *)&boundaryNames);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoundaryAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
BoundaryAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_colorType:        return "colorType";
    case ID_colorTableName:   return "colorTableName";
    case ID_invertColorTable: return "invertColorTable";
    case ID_legendFlag:       return "legendFlag";
    case ID_lineWidth:        return "lineWidth";
    case ID_singleColor:      return "singleColor";
    case ID_multiColor:       return "multiColor";
    case ID_boundaryNames:    return "boundaryNames";
    case ID_opacity:          return "opacity";
    case ID_wireframe:        return "wireframe";
    case ID_smoothingLevel:   return "smoothingLevel";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoundaryAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
BoundaryAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_colorType:        return FieldType_enum;
    case ID_colorTableName:   return FieldType_colortable;
    case ID_invertColorTable: return FieldType_bool;
    case ID_legendFlag:       return FieldType_bool;
    case ID_lineWidth:        return FieldType_linewidth;
    case ID_singleColor:      return FieldType_color;
    case ID_multiColor:       return FieldType_att;
    case ID_boundaryNames:    return FieldType_stringVector;
    case ID_opacity:          return FieldType_opacity;
    case ID_wireframe:        return FieldType_bool;
    case ID_smoothingLevel:   return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: BoundaryAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
BoundaryAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_colorType:        return "enum";
    case ID_colorTableName:   return "colortable";
    case ID_invertColorTable: return "bool";
    case ID_legendFlag:       return "bool";
    case ID_lineWidth:        return "linewidth";
    case ID_singleColor:      return "color";
    case ID_multiColor:       return "att";
    case ID_boundaryNames:    return "stringVector";
    case ID_opacity:          return "opacity";
    case ID_wireframe:        return "bool";
    case ID_smoothingLevel:   return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoundaryAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const BoundaryAttributes &obj = *((const BoundaryAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_colorType:
        {  // new scope
        retval = (colorType == obj.colorType);
        }
        break;
    case ID_colorTableName:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case ID_invertColorTable:
        {  // new scope
        retval = (invertColorTable == obj.invertColorTable);
        }
        break;
    case ID_legendFlag:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_singleColor:
        {  // new scope
        retval = (singleColor == obj.singleColor);
        }
        break;
    case ID_multiColor:
        {  // new scope
        retval = (multiColor == obj.multiColor);
        }
        break;
    case ID_boundaryNames:
        {  // new scope
        retval = (boundaryNames == obj.boundaryNames);
        }
        break;
    case ID_opacity:
        {  // new scope
        retval = (opacity == obj.opacity);
        }
        break;
    case ID_wireframe:
        {  // new scope
        retval = (wireframe == obj.wireframe);
        }
        break;
    case ID_smoothingLevel:
        {  // new scope
        retval = (smoothingLevel == obj.smoothingLevel);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Modifications:
//    Jeremy Meredith, Mon Dec  9 16:30:54 PST 2002
//    Added smoothing level.
//
//    Kathleen Bonnell, Wed Nov 10 09:37:01 PST 2004
//    Added needsSecondaryVar.
//
//    Kathleen Biagas, Tue Dec 20 14:08:20 PST 2016
//    Removed needSecondaryVar, filledFlag, boundaryType.
//
// ****************************************************************************
bool
BoundaryAttributes::ChangesRequireRecalculation(const BoundaryAttributes &obj)
{
    return ((boundaryNames != obj.boundaryNames) ||
            (wireframe != obj.wireframe) ||
            (smoothingLevel != obj.smoothingLevel));
}

bool
BoundaryAttributes::VarChangeRequiresReset()
{
    return true;
}

// ****************************************************************************
// Method: BoundaryAttributes::ProcessOldVersions
//
// Purpose:
//   This method allows handling of older config/session files that may
//   contain fields that are no longer present or have been modified/renamed.
//
// Programmer: Jeremy Meredith
// Creation:   June 18, 2003
//
// Modifications:
//    Kathleen Biagas, Tue Dec 20 14:08:20 PST 2016
//    Added items for configVersion < 2.13.0: boundaryType, filledFlag,
//    pointSize, pointSizeVarEnabled, pointSizeVar, pointSizePixels, pointType.
//
// ****************************************************************************
void
BoundaryAttributes::ProcessOldVersions(DataNode *parentNode,
                                       const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("BoundaryAttributes");
    if(searchNode == 0)
        return;

    if (VersionLessThan(configVersion, "1.1.5"))
    {
        if (searchNode->GetNode("wireframe") != 0)
            searchNode->RemoveNode("wireframe");
    }

    if (VersionLessThan(configVersion, "2.13.0"))
    {
        if (searchNode->GetNode("boundaryType") != 0)
            searchNode->RemoveNode("boundaryType");
        if (searchNode->GetNode("pointSize") != 0)
            searchNode->RemoveNode("pointSize");
        if (searchNode->GetNode("pointSizeVarEnabled") != 0)
            searchNode->RemoveNode("pointSizeVarEnabled");
        if (searchNode->GetNode("pointSizeVar") != 0)
            searchNode->RemoveNode("pointSizeVar");
        if (searchNode->GetNode("pointSizePixels") != 0)
            searchNode->RemoveNode("pointSizePixels");
        if (searchNode->GetNode("pointType") != 0)
            searchNode->RemoveNode("pointType");
        if (searchNode->GetNode("filledFlag") != 0)
            searchNode->RemoveNode("filledFlag");
    }
    if (VersionLessThan(configVersion, "3.0.0"))
    {
        if (searchNode->GetNode("lineStyle") != 0)
            searchNode->RemoveNode("lineStyle");
    }
}

