// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ZoneDumpViewerEnginePluginInfo.C
// ****************************************************************************

#include <ZoneDumpPluginInfo.h>
#include <ZoneDumpAttributes.h>

//
// Storage for static data elements.
//
ZoneDumpAttributes *ZoneDumpViewerEnginePluginInfo::clientAtts = NULL;
ZoneDumpAttributes *ZoneDumpViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ZoneDumpViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ZoneDumpViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ZoneDumpViewerEnginePluginInfo::clientAtts == NULL)
    {
        ZoneDumpViewerEnginePluginInfo::clientAtts  = new ZoneDumpAttributes;
        ZoneDumpViewerEnginePluginInfo::defaultAtts = new ZoneDumpAttributes;
    }
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ZoneDumpViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ZoneDumpViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ZoneDumpViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ZoneDumpAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ZoneDumpViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ZoneDumpAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ZoneDumpViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ZoneDumpAttributes*)atts = *defaultAtts;
    else
        *(ZoneDumpAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ZoneDumpViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ZoneDumpViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZoneDumpViewerEnginePluginInfo::GetMenuName() const
{
    return "Zone Dump";
}

