// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ZoneDumpScriptingPluginInfo.C
// ************************************************************************* //
#include <PyZoneDumpAttributes.h>
#include <ZoneDumpPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ZoneDump,Scripting)

// ****************************************************************************
// Method: ZoneDumpScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ZoneDumpScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyZoneDumpAttributes_StartUp((ZoneDumpAttributes *)subj, data);
}

// ****************************************************************************
// Method: ZoneDumpScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ZoneDumpScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyZoneDumpAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ZoneDumpScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ZoneDump plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ZoneDumpScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyZoneDumpAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ZoneDumpScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ZoneDumpScriptingPluginInfo::GetLogString()
{
    std::string s(PyZoneDumpAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ZoneDumpScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ZoneDumpScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyZoneDumpAttributes_SetDefaults((const ZoneDumpAttributes *)atts);
}
