// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ZoneDumpPluginInfo.h
// ****************************************************************************

#ifndef ZONEDUMP_PLUGIN_INFO_H
#define ZONEDUMP_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ZoneDumpAttributes;

// ****************************************************************************
//  Class: ZoneDumpPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an ZoneDump operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ZoneDumpGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ZoneDumpCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ZoneDumpGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ZoneDumpGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ZoneDumpCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class ZoneDumpViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ZoneDumpCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ZoneDumpAttributes *defaultAtts;
    static ZoneDumpAttributes *clientAtts;
};

class ZoneDumpViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ZoneDumpViewerEnginePluginInfo
{
  public:
};

class ZoneDumpEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ZoneDumpViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ZoneDumpScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ZoneDumpCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
