// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ZoneDumpPluginInfo.C
// ****************************************************************************

#include <ZoneDumpPluginInfo.h>
#include <ZoneDumpAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ZoneDump,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(ZoneDump,General)

// ****************************************************************************
//  Method: ZoneDumpGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZoneDumpGeneralPluginInfo::GetName() const
{
    return "ZoneDump";
}

// ****************************************************************************
//  Method: ZoneDumpGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZoneDumpGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ZoneDumpGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZoneDumpGeneralPluginInfo::GetID() const
{
    return "ZoneDump_1.0";
}
// ****************************************************************************
//  Method: ZoneDumpGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ZoneDumpGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}

// ****************************************************************************
//  Method: ZoneDumpGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZoneDumpGeneralPluginInfo::GetCategoryName() const
{
    return "Debugging";
}
