// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ZoneDumpCommonPluginInfo.C
// ****************************************************************************

#include <ZoneDumpPluginInfo.h>
#include <ZoneDumpAttributes.h>

// ****************************************************************************
//  Method: ZoneDumpCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ZoneDumpCommonPluginInfo::AllocAttributes()
{
    return new ZoneDumpAttributes;
}

// ****************************************************************************
//  Method: ZoneDumpCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ZoneDump attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ZoneDumpCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ZoneDumpAttributes *) to) = *((ZoneDumpAttributes *) from);
}
