// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TubePluginInfo.h
// ****************************************************************************

#ifndef TUBE_PLUGIN_INFO_H
#define TUBE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class TubeAttributes;

// ****************************************************************************
//  Class: TubePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Tube operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class TubeGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class TubeCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual TubeGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class TubeGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual TubeCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class TubeViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual TubeCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static TubeAttributes *defaultAtts;
    static TubeAttributes *clientAtts;
};

class TubeViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual TubeViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class TubeEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual TubeViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class TubeScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual TubeCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
