// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef TUBEATTRIBUTES_H
#define TUBEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: TubeAttributes
//
// Purpose:
//    This class contains attributes for the tube operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class TubeAttributes : public AttributeSubject
{
public:
    enum TubeRadiusType
    {
        FractionOfBBox,
        Absolute
    };

    // These constructors are for objects of this class
    TubeAttributes();
    TubeAttributes(const TubeAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    TubeAttributes(private_tmfs_t tmfs);
    TubeAttributes(const TubeAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~TubeAttributes();

    virtual TubeAttributes& operator = (const TubeAttributes &obj);
    virtual bool operator == (const TubeAttributes &obj) const;
    virtual bool operator != (const TubeAttributes &obj) const;
private:
    void Init();
    void Copy(const TubeAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectScaleVariable();

    // Property setting methods
    void SetScaleByVarFlag(bool scaleByVarFlag_);
    void SetTubeRadiusType(TubeRadiusType tubeRadiusType_);
    void SetRadiusFractionBBox(double radiusFractionBBox_);
    void SetRadiusAbsolute(double radiusAbsolute_);
    void SetScaleVariable(const std::string &scaleVariable_);
    void SetFineness(int fineness_);
    void SetCapping(bool capping_);

    // Property getting methods
    bool              GetScaleByVarFlag() const;
    TubeRadiusType    GetTubeRadiusType() const;
    double            GetRadiusFractionBBox() const;
    double            GetRadiusAbsolute() const;
    const std::string &GetScaleVariable() const;
          std::string &GetScaleVariable();
    int               GetFineness() const;
    bool              GetCapping() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string TubeRadiusType_ToString(TubeRadiusType);
    static bool TubeRadiusType_FromString(const std::string &, TubeRadiusType &);
protected:
    static std::string TubeRadiusType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_scaleByVarFlag = 0,
        ID_tubeRadiusType,
        ID_radiusFractionBBox,
        ID_radiusAbsolute,
        ID_scaleVariable,
        ID_fineness,
        ID_capping,
        ID__LAST
    };

private:
    bool        scaleByVarFlag;
    int         tubeRadiusType;
    double      radiusFractionBBox;
    double      radiusAbsolute;
    std::string scaleVariable;
    int         fineness;
    bool        capping;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define TUBEATTRIBUTES_TMFS "biddsib"

#endif
