// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TriangulateRegularPointsPluginInfo.h
// ****************************************************************************

#ifndef TRIANGULATEREGULARPOINTS_PLUGIN_INFO_H
#define TRIANGULATEREGULARPOINTS_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class TriangulateRegularPointsAttributes;

// ****************************************************************************
//  Class: TriangulateRegularPointsPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an TriangulateRegularPoints operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class TriangulateRegularPointsGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class TriangulateRegularPointsCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual TriangulateRegularPointsGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class TriangulateRegularPointsGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual TriangulateRegularPointsCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class TriangulateRegularPointsViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual TriangulateRegularPointsCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static TriangulateRegularPointsAttributes *defaultAtts;
    static TriangulateRegularPointsAttributes *clientAtts;
};

class TriangulateRegularPointsViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual TriangulateRegularPointsViewerEnginePluginInfo
{
  public:
};

class TriangulateRegularPointsEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual TriangulateRegularPointsViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class TriangulateRegularPointsScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual TriangulateRegularPointsCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
