// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TriangulateRegularPointsGUIPluginInfo.C
// ****************************************************************************

#include <TriangulateRegularPointsPluginInfo.h>
#include <TriangulateRegularPointsAttributes.h>
#include <QApplication>
#include <QvisTriangulateRegularPointsWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(TriangulateRegularPoints,GUI)

// ****************************************************************************
//  Method: TriangulateRegularPointsGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
TriangulateRegularPointsGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Triangulate Regular Points"));
}


// ****************************************************************************
//  Method: TriangulateRegularPointsGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
TriangulateRegularPointsGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisTriangulateRegularPointsWindow(type, (TriangulateRegularPointsAttributes *)attr,
        caption, shortName, notepad);
}

