// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyTriangulateRegularPointsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyTriangulateRegularPointsAttributes
//
// Purpose:
//   Attributes for the triangulate regular points operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TriangulateRegularPointsAttributes.
//
struct TriangulateRegularPointsAttributesObject
{
    PyObject_HEAD
    TriangulateRegularPointsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTriangulateRegularPointsAttributes(int);

std::string
PyTriangulateRegularPointsAttributes_ToString(const TriangulateRegularPointsAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetUseXGridSpacing())
        snprintf(tmpStr, 1000, "%suseXGridSpacing = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseXGridSpacing = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sxGridSpacing = %g\n", prefix, atts->GetXGridSpacing());
    str += tmpStr;
    if(atts->GetUseYGridSpacing())
        snprintf(tmpStr, 1000, "%suseYGridSpacing = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseYGridSpacing = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%syGridSpacing = %g\n", prefix, atts->GetYGridSpacing());
    str += tmpStr;
    return str;
}

static PyObject *
TriangulateRegularPointsAttributes_Notify(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_SetUseXGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useXGridSpacing in the object.
    obj->data->SetUseXGridSpacing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_GetUseXGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseXGridSpacing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_SetXGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xGridSpacing in the object.
    obj->data->SetXGridSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_GetXGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXGridSpacing());
    return retval;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_SetUseYGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useYGridSpacing in the object.
    obj->data->SetUseYGridSpacing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_GetUseYGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseYGridSpacing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_SetYGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yGridSpacing in the object.
    obj->data->SetYGridSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TriangulateRegularPointsAttributes_GetYGridSpacing(PyObject *self, PyObject *args)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYGridSpacing());
    return retval;
}



PyMethodDef PyTriangulateRegularPointsAttributes_methods[TRIANGULATEREGULARPOINTSATTRIBUTES_NMETH] = {
    {"Notify", TriangulateRegularPointsAttributes_Notify, METH_VARARGS},
    {"SetUseXGridSpacing", TriangulateRegularPointsAttributes_SetUseXGridSpacing, METH_VARARGS},
    {"GetUseXGridSpacing", TriangulateRegularPointsAttributes_GetUseXGridSpacing, METH_VARARGS},
    {"SetXGridSpacing", TriangulateRegularPointsAttributes_SetXGridSpacing, METH_VARARGS},
    {"GetXGridSpacing", TriangulateRegularPointsAttributes_GetXGridSpacing, METH_VARARGS},
    {"SetUseYGridSpacing", TriangulateRegularPointsAttributes_SetUseYGridSpacing, METH_VARARGS},
    {"GetUseYGridSpacing", TriangulateRegularPointsAttributes_GetUseYGridSpacing, METH_VARARGS},
    {"SetYGridSpacing", TriangulateRegularPointsAttributes_SetYGridSpacing, METH_VARARGS},
    {"GetYGridSpacing", TriangulateRegularPointsAttributes_GetYGridSpacing, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TriangulateRegularPointsAttributes_dealloc(PyObject *v)
{
   TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TriangulateRegularPointsAttributes_compare(PyObject *v, PyObject *w)
{
    TriangulateRegularPointsAttributes *a = ((TriangulateRegularPointsAttributesObject *)v)->data;
    TriangulateRegularPointsAttributes *b = ((TriangulateRegularPointsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTriangulateRegularPointsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useXGridSpacing") == 0)
        return TriangulateRegularPointsAttributes_GetUseXGridSpacing(self, NULL);
    if(strcmp(name, "xGridSpacing") == 0)
        return TriangulateRegularPointsAttributes_GetXGridSpacing(self, NULL);
    if(strcmp(name, "useYGridSpacing") == 0)
        return TriangulateRegularPointsAttributes_GetUseYGridSpacing(self, NULL);
    if(strcmp(name, "yGridSpacing") == 0)
        return TriangulateRegularPointsAttributes_GetYGridSpacing(self, NULL);

    return Py_FindMethod(PyTriangulateRegularPointsAttributes_methods, self, name);
}

int
PyTriangulateRegularPointsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "useXGridSpacing") == 0)
        obj = TriangulateRegularPointsAttributes_SetUseXGridSpacing(self, tuple);
    else if(strcmp(name, "xGridSpacing") == 0)
        obj = TriangulateRegularPointsAttributes_SetXGridSpacing(self, tuple);
    else if(strcmp(name, "useYGridSpacing") == 0)
        obj = TriangulateRegularPointsAttributes_SetUseYGridSpacing(self, tuple);
    else if(strcmp(name, "yGridSpacing") == 0)
        obj = TriangulateRegularPointsAttributes_SetYGridSpacing(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TriangulateRegularPointsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)v;
    fprintf(fp, "%s", PyTriangulateRegularPointsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TriangulateRegularPointsAttributes_str(PyObject *v)
{
    TriangulateRegularPointsAttributesObject *obj = (TriangulateRegularPointsAttributesObject *)v;
    return PyString_FromString(PyTriangulateRegularPointsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TriangulateRegularPointsAttributes_Purpose = "Attributes for the triangulate regular points operator";
#else
static char *TriangulateRegularPointsAttributes_Purpose = "Attributes for the triangulate regular points operator";
#endif

//
// The type description structure
//
static PyTypeObject TriangulateRegularPointsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TriangulateRegularPointsAttributes",                    // tp_name
    sizeof(TriangulateRegularPointsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TriangulateRegularPointsAttributes_dealloc,  // tp_dealloc
    (printfunc)TriangulateRegularPointsAttributes_print,     // tp_print
    (getattrfunc)PyTriangulateRegularPointsAttributes_getattr, // tp_getattr
    (setattrfunc)PyTriangulateRegularPointsAttributes_setattr, // tp_setattr
    (cmpfunc)TriangulateRegularPointsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TriangulateRegularPointsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TriangulateRegularPointsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TriangulateRegularPointsAttributes *defaultAtts = 0;
static TriangulateRegularPointsAttributes *currentAtts = 0;

static PyObject *
NewTriangulateRegularPointsAttributes(int useCurrent)
{
    TriangulateRegularPointsAttributesObject *newObject;
    newObject = PyObject_NEW(TriangulateRegularPointsAttributesObject, &TriangulateRegularPointsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TriangulateRegularPointsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TriangulateRegularPointsAttributes(*defaultAtts);
    else
        newObject->data = new TriangulateRegularPointsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTriangulateRegularPointsAttributes(const TriangulateRegularPointsAttributes *attr)
{
    TriangulateRegularPointsAttributesObject *newObject;
    newObject = PyObject_NEW(TriangulateRegularPointsAttributesObject, &TriangulateRegularPointsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TriangulateRegularPointsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TriangulateRegularPointsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTriangulateRegularPointsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TriangulateRegularPointsAttributesMethods[] = {
    {"TriangulateRegularPointsAttributes", TriangulateRegularPointsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TriangulateRegularPointsAttributesObserver = 0;

std::string
PyTriangulateRegularPointsAttributes_GetLogString()
{
    std::string s("TriangulateRegularPointsAtts = TriangulateRegularPointsAttributes()\n");
    if(currentAtts != 0)
        s += PyTriangulateRegularPointsAttributes_ToString(currentAtts, "TriangulateRegularPointsAtts.");
    return s;
}

static void
PyTriangulateRegularPointsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TriangulateRegularPointsAtts = TriangulateRegularPointsAttributes()\n");
        s += PyTriangulateRegularPointsAttributes_ToString(currentAtts, "TriangulateRegularPointsAtts.");
        cb(s);
    }
}

void
PyTriangulateRegularPointsAttributes_StartUp(TriangulateRegularPointsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTriangulateRegularPointsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TriangulateRegularPointsAttributesObserver == 0)
    {
        TriangulateRegularPointsAttributesObserver = new ObserverToCallback(subj,
            PyTriangulateRegularPointsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTriangulateRegularPointsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TriangulateRegularPointsAttributesObserver;
    TriangulateRegularPointsAttributesObserver = 0;
}

PyMethodDef *
PyTriangulateRegularPointsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TriangulateRegularPointsAttributesMethods;
}

bool
PyTriangulateRegularPointsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TriangulateRegularPointsAttributesType);
}

TriangulateRegularPointsAttributes *
PyTriangulateRegularPointsAttributes_FromPyObject(PyObject *obj)
{
    TriangulateRegularPointsAttributesObject *obj2 = (TriangulateRegularPointsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTriangulateRegularPointsAttributes_New()
{
    return NewTriangulateRegularPointsAttributes(0);
}

PyObject *
PyTriangulateRegularPointsAttributes_Wrap(const TriangulateRegularPointsAttributes *attr)
{
    return WrapTriangulateRegularPointsAttributes(attr);
}

void
PyTriangulateRegularPointsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TriangulateRegularPointsAttributesObject *obj2 = (TriangulateRegularPointsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTriangulateRegularPointsAttributes_SetDefaults(const TriangulateRegularPointsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TriangulateRegularPointsAttributes(*atts);
}

