// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TransformCommonPluginInfo.C
// ****************************************************************************

#include <TransformPluginInfo.h>
#include <TransformAttributes.h>

// ****************************************************************************
//  Method: TransformCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TransformCommonPluginInfo::AllocAttributes()
{
    return new TransformAttributes;
}

// ****************************************************************************
//  Method: TransformCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Transform attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TransformCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TransformAttributes *) to) = *((TransformAttributes *) from);
}
