// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ToroidalPoloidalProjectionViewerEnginePluginInfo.C
// ****************************************************************************

#include <ToroidalPoloidalProjectionPluginInfo.h>
#include <ToroidalPoloidalProjection.h>

//
// Storage for static data elements.
//
ToroidalPoloidalProjection *ToroidalPoloidalProjectionViewerEnginePluginInfo::clientAtts = NULL;
ToroidalPoloidalProjection *ToroidalPoloidalProjectionViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ToroidalPoloidalProjectionViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ToroidalPoloidalProjectionViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ToroidalPoloidalProjectionViewerEnginePluginInfo::clientAtts == NULL)
    {
        ToroidalPoloidalProjectionViewerEnginePluginInfo::clientAtts  = new ToroidalPoloidalProjection;
        ToroidalPoloidalProjectionViewerEnginePluginInfo::defaultAtts = new ToroidalPoloidalProjection;
    }
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ToroidalPoloidalProjectionViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ToroidalPoloidalProjectionViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ToroidalPoloidalProjectionViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ToroidalPoloidalProjection *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ToroidalPoloidalProjectionViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ToroidalPoloidalProjection *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ToroidalPoloidalProjectionViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ToroidalPoloidalProjection*)atts = *defaultAtts;
    else
        *(ToroidalPoloidalProjection*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ToroidalPoloidalProjectionViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ToroidalPoloidalProjectionViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ToroidalPoloidalProjectionViewerEnginePluginInfo::GetMenuName() const
{
    return "ToroidalPoloidalProjection";
}

