// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ToroidalPoloidalProjectionScriptingPluginInfo.C
// ************************************************************************* //
#include <PyToroidalPoloidalProjection.h>
#include <ToroidalPoloidalProjectionPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ToroidalPoloidalProjection,Scripting)

// ****************************************************************************
// Method: ToroidalPoloidalProjectionScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ToroidalPoloidalProjectionScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyToroidalPoloidalProjection_StartUp((ToroidalPoloidalProjection *)subj, data);
}

// ****************************************************************************
// Method: ToroidalPoloidalProjectionScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ToroidalPoloidalProjectionScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyToroidalPoloidalProjection_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ToroidalPoloidalProjectionScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ToroidalPoloidalProjection plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ToroidalPoloidalProjectionScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyToroidalPoloidalProjection_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ToroidalPoloidalProjectionScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ToroidalPoloidalProjectionScriptingPluginInfo::GetLogString()
{
    std::string s(PyToroidalPoloidalProjection_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ToroidalPoloidalProjectionScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ToroidalPoloidalProjectionScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyToroidalPoloidalProjection_SetDefaults((const ToroidalPoloidalProjection *)atts);
}
