// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ToroidalPoloidalProjectionPluginInfo.h
// ****************************************************************************

#ifndef TOROIDALPOLOIDALPROJECTION_PLUGIN_INFO_H
#define TOROIDALPOLOIDALPROJECTION_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ToroidalPoloidalProjection;

// ****************************************************************************
//  Class: ToroidalPoloidalProjectionPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an ToroidalPoloidalProjection operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ToroidalPoloidalProjectionGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ToroidalPoloidalProjectionCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ToroidalPoloidalProjectionGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ToroidalPoloidalProjectionGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ToroidalPoloidalProjectionCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class ToroidalPoloidalProjectionViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ToroidalPoloidalProjectionCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ToroidalPoloidalProjection *defaultAtts;
    static ToroidalPoloidalProjection *clientAtts;
};

class ToroidalPoloidalProjectionViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ToroidalPoloidalProjectionViewerEnginePluginInfo
{
  public:
};

class ToroidalPoloidalProjectionEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ToroidalPoloidalProjectionViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ToroidalPoloidalProjectionScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ToroidalPoloidalProjectionCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
