// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ThresholdPluginInfo.h
// ****************************************************************************

#ifndef THRESHOLD_PLUGIN_INFO_H
#define THRESHOLD_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ThresholdAttributes;

// ****************************************************************************
//  Class: ThresholdPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Threshold operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ThresholdGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ThresholdCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ThresholdGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ThresholdGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ThresholdViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ThresholdAttributes *defaultAtts;
    static ThresholdAttributes *clientAtts;
};

class ThresholdViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ThresholdViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ThresholdEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ThresholdViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ThresholdScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
