// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ThresholdCommonPluginInfo.C
// ****************************************************************************

#include <ThresholdPluginInfo.h>
#include <ThresholdAttributes.h>

// ****************************************************************************
//  Method: ThresholdCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThresholdCommonPluginInfo::AllocAttributes()
{
    return new ThresholdAttributes;
}

// ****************************************************************************
//  Method: ThresholdCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Threshold attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ThresholdAttributes *) to) = *((ThresholdAttributes *) from);
}
