// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ThreeSlicePluginInfo.C
// ****************************************************************************

#include <ThreeSlicePluginInfo.h>
#include <ThreeSliceAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ThreeSlice,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(ThreeSlice,General)

// ****************************************************************************
//  Method: ThreeSliceGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThreeSliceGeneralPluginInfo::GetName() const
{
    return "ThreeSlice";
}

// ****************************************************************************
//  Method: ThreeSliceGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThreeSliceGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ThreeSliceGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThreeSliceGeneralPluginInfo::GetID() const
{
    return "ThreeSlice_1.0";
}
// ****************************************************************************
//  Method: ThreeSliceGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ThreeSliceGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: ThreeSliceGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThreeSliceGeneralPluginInfo::GetCategoryName() const
{
    return "Slicing";
}
