// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ThreeSliceCommonPluginInfo.C
// ****************************************************************************

#include <ThreeSlicePluginInfo.h>
#include <ThreeSliceAttributes.h>

// ****************************************************************************
//  Method: ThreeSliceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThreeSliceCommonPluginInfo::AllocAttributes()
{
    return new ThreeSliceAttributes;
}

// ****************************************************************************
//  Method: ThreeSliceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ThreeSlice attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThreeSliceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ThreeSliceAttributes *) to) = *((ThreeSliceAttributes *) from);
}
