// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef THREESLICEATTRIBUTES_H
#define THREESLICEATTRIBUTES_H
#include <AttributeSubject.h>

#include <PointAttributes.h>

// ****************************************************************************
// Class: ThreeSliceAttributes
//
// Purpose:
//    This class contains attributes for the threeslice operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ThreeSliceAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ThreeSliceAttributes();
    ThreeSliceAttributes(const ThreeSliceAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ThreeSliceAttributes(private_tmfs_t tmfs);
    ThreeSliceAttributes(const ThreeSliceAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ThreeSliceAttributes();

    virtual ThreeSliceAttributes& operator = (const ThreeSliceAttributes &obj);
    virtual bool operator == (const ThreeSliceAttributes &obj) const;
    virtual bool operator != (const ThreeSliceAttributes &obj) const;
private:
    void Init();
    void Copy(const ThreeSliceAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetX(double x_);
    void SetY(double y_);
    void SetZ(double z_);
    void SetInteractive(bool interactive_);

    // Property getting methods
    double GetX() const;
    double GetY() const;
    double GetZ() const;
    bool   GetInteractive() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_x = 0,
        ID_y,
        ID_z,
        ID_interactive,
        ID__LAST
    };

private:
    double x;
    double y;
    double z;
    bool   interactive;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define THREESLICEATTRIBUTES_TMFS "dddb"

#endif
