// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyThreeSliceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyThreeSliceAttributes
//
// Purpose:
//   This class contains attributes for the threeslice operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ThreeSliceAttributes.
//
struct ThreeSliceAttributesObject
{
    PyObject_HEAD
    ThreeSliceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewThreeSliceAttributes(int);

std::string
PyThreeSliceAttributes_ToString(const ThreeSliceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sx = %g\n", prefix, atts->GetX());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sy = %g\n", prefix, atts->GetY());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sz = %g\n", prefix, atts->GetZ());
    str += tmpStr;
    if(atts->GetInteractive())
        snprintf(tmpStr, 1000, "%sinteractive = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sinteractive = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ThreeSliceAttributes_Notify(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThreeSliceAttributes_SetX(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the x in the object.
    obj->data->SetX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThreeSliceAttributes_GetX(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetX());
    return retval;
}

/*static*/ PyObject *
ThreeSliceAttributes_SetY(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the y in the object.
    obj->data->SetY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThreeSliceAttributes_GetY(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetY());
    return retval;
}

/*static*/ PyObject *
ThreeSliceAttributes_SetZ(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the z in the object.
    obj->data->SetZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThreeSliceAttributes_GetZ(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZ());
    return retval;
}

/*static*/ PyObject *
ThreeSliceAttributes_SetInteractive(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the interactive in the object.
    obj->data->SetInteractive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThreeSliceAttributes_GetInteractive(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInteractive()?1L:0L);
    return retval;
}



PyMethodDef PyThreeSliceAttributes_methods[THREESLICEATTRIBUTES_NMETH] = {
    {"Notify", ThreeSliceAttributes_Notify, METH_VARARGS},
    {"SetX", ThreeSliceAttributes_SetX, METH_VARARGS},
    {"GetX", ThreeSliceAttributes_GetX, METH_VARARGS},
    {"SetY", ThreeSliceAttributes_SetY, METH_VARARGS},
    {"GetY", ThreeSliceAttributes_GetY, METH_VARARGS},
    {"SetZ", ThreeSliceAttributes_SetZ, METH_VARARGS},
    {"GetZ", ThreeSliceAttributes_GetZ, METH_VARARGS},
    {"SetInteractive", ThreeSliceAttributes_SetInteractive, METH_VARARGS},
    {"GetInteractive", ThreeSliceAttributes_GetInteractive, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ThreeSliceAttributes_dealloc(PyObject *v)
{
   ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ThreeSliceAttributes_compare(PyObject *v, PyObject *w)
{
    ThreeSliceAttributes *a = ((ThreeSliceAttributesObject *)v)->data;
    ThreeSliceAttributes *b = ((ThreeSliceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyThreeSliceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "x") == 0)
        return ThreeSliceAttributes_GetX(self, NULL);
    if(strcmp(name, "y") == 0)
        return ThreeSliceAttributes_GetY(self, NULL);
    if(strcmp(name, "z") == 0)
        return ThreeSliceAttributes_GetZ(self, NULL);
    if(strcmp(name, "interactive") == 0)
        return ThreeSliceAttributes_GetInteractive(self, NULL);

    return Py_FindMethod(PyThreeSliceAttributes_methods, self, name);
}

int
PyThreeSliceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "x") == 0)
        obj = ThreeSliceAttributes_SetX(self, tuple);
    else if(strcmp(name, "y") == 0)
        obj = ThreeSliceAttributes_SetY(self, tuple);
    else if(strcmp(name, "z") == 0)
        obj = ThreeSliceAttributes_SetZ(self, tuple);
    else if(strcmp(name, "interactive") == 0)
        obj = ThreeSliceAttributes_SetInteractive(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ThreeSliceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)v;
    fprintf(fp, "%s", PyThreeSliceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ThreeSliceAttributes_str(PyObject *v)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)v;
    return PyString_FromString(PyThreeSliceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ThreeSliceAttributes_Purpose = "This class contains attributes for the threeslice operator.";
#else
static char *ThreeSliceAttributes_Purpose = "This class contains attributes for the threeslice operator.";
#endif

//
// The type description structure
//
static PyTypeObject ThreeSliceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ThreeSliceAttributes",                    // tp_name
    sizeof(ThreeSliceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ThreeSliceAttributes_dealloc,  // tp_dealloc
    (printfunc)ThreeSliceAttributes_print,     // tp_print
    (getattrfunc)PyThreeSliceAttributes_getattr, // tp_getattr
    (setattrfunc)PyThreeSliceAttributes_setattr, // tp_setattr
    (cmpfunc)ThreeSliceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ThreeSliceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ThreeSliceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ThreeSliceAttributes *defaultAtts = 0;
static ThreeSliceAttributes *currentAtts = 0;

static PyObject *
NewThreeSliceAttributes(int useCurrent)
{
    ThreeSliceAttributesObject *newObject;
    newObject = PyObject_NEW(ThreeSliceAttributesObject, &ThreeSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ThreeSliceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ThreeSliceAttributes(*defaultAtts);
    else
        newObject->data = new ThreeSliceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapThreeSliceAttributes(const ThreeSliceAttributes *attr)
{
    ThreeSliceAttributesObject *newObject;
    newObject = PyObject_NEW(ThreeSliceAttributesObject, &ThreeSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ThreeSliceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ThreeSliceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewThreeSliceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ThreeSliceAttributesMethods[] = {
    {"ThreeSliceAttributes", ThreeSliceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ThreeSliceAttributesObserver = 0;

std::string
PyThreeSliceAttributes_GetLogString()
{
    std::string s("ThreeSliceAtts = ThreeSliceAttributes()\n");
    if(currentAtts != 0)
        s += PyThreeSliceAttributes_ToString(currentAtts, "ThreeSliceAtts.");
    return s;
}

static void
PyThreeSliceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ThreeSliceAtts = ThreeSliceAttributes()\n");
        s += PyThreeSliceAttributes_ToString(currentAtts, "ThreeSliceAtts.");
        cb(s);
    }
}

void
PyThreeSliceAttributes_StartUp(ThreeSliceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyThreeSliceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ThreeSliceAttributesObserver == 0)
    {
        ThreeSliceAttributesObserver = new ObserverToCallback(subj,
            PyThreeSliceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyThreeSliceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ThreeSliceAttributesObserver;
    ThreeSliceAttributesObserver = 0;
}

PyMethodDef *
PyThreeSliceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ThreeSliceAttributesMethods;
}

bool
PyThreeSliceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ThreeSliceAttributesType);
}

ThreeSliceAttributes *
PyThreeSliceAttributes_FromPyObject(PyObject *obj)
{
    ThreeSliceAttributesObject *obj2 = (ThreeSliceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyThreeSliceAttributes_New()
{
    return NewThreeSliceAttributes(0);
}

PyObject *
PyThreeSliceAttributes_Wrap(const ThreeSliceAttributes *attr)
{
    return WrapThreeSliceAttributes(attr);
}

void
PyThreeSliceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ThreeSliceAttributesObject *obj2 = (ThreeSliceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyThreeSliceAttributes_SetDefaults(const ThreeSliceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ThreeSliceAttributes(*atts);
}

