// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtSurfaceNormalFilter.C
// ************************************************************************* //

#include <avtSurfaceNormalFilter.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <ParsingExprList.h>


// ****************************************************************************
//  Method: avtSurfaceNormalFilter constructor
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

avtSurfaceNormalFilter::avtSurfaceNormalFilter()
{
}


// ****************************************************************************
//  Method: avtSurfaceNormalFilter destructor
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
//  Modifications:
//
// ****************************************************************************

avtSurfaceNormalFilter::~avtSurfaceNormalFilter()
{
}


// ****************************************************************************
//  Method:  avtSurfaceNormalFilter::Create
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

avtFilter *
avtSurfaceNormalFilter::Create()
{
    return new avtSurfaceNormalFilter();
}


// ****************************************************************************
//  Method:      avtSurfaceNormalFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

void
avtSurfaceNormalFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const SurfaceNormalAttributes*)a;
}


// ****************************************************************************
//  Method: avtSurfaceNormalFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtSurfaceNormalFilter with the given
//      parameters would result in an equivalent avtSurfaceNormalFilter.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

bool
avtSurfaceNormalFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(SurfaceNormalAttributes*)a);
}


// ****************************************************************************
//  Method: avtSurfaceNormalFilter::InferVariableNameFromContract
//
//  Purpose:
//      Studies the contract and determines the name of the variable we
//      are supposed to produce.
//
//  Programmer: Hank Childs
//  Creation:   September 24, 2010
//
// ****************************************************************************

void
avtSurfaceNormalFilter::InferVariableNameFromContract(avtContract_p c)
{
    avtDataRequest_p in_dr = c->GetDataRequest();

    bool foundIt = false;
    if (strncmp(in_dr->GetVariable(), "operators/SurfaceNormal/", 
                strlen("operators/SurfaceNormal/")) == 0)
    {
        foundIt = true;
        varname = in_dr->GetVariable()+strlen("operators/SurfaceNormal/");
    }

    if (!foundIt)
    {
        std::vector<CharStrRef>   vars2nd = in_dr->GetSecondaryVariablesWithoutDuplicates();
        for (size_t i = 0 ; i < vars2nd.size() ; i++)
        if (strncmp(*(vars2nd[i]), "operators/SurfaceNormal/", 
                    strlen("operators/SurfaceNormal/")) == 0)
        {
            foundIt = true;
            varname = *(vars2nd[i])+strlen("operators/SurfaceNormal/");
        }
    }

    if (!foundIt)
    {
        EXCEPTION1(VisItException, "Unable to determine variable name from contract");
    }
}


// ****************************************************************************
//  Method: avtSurfaceNormalFilter::GetCustomExpressions
//
//  Purpose:
//      Gets the expression definitions that should be used when executing
//      this filter.
//
//  Programmer: Hank Childs
//  Creation:   September 24, 2010
//
// ****************************************************************************

void 
avtSurfaceNormalFilter::GetCustomExpressions(std::vector<Expression> &elist)
{
    Expression exp;
    char fullname[1024];
    snprintf(fullname, 1024, "operators/SurfaceNormal/%s", varname.c_str());
    exp.SetName(fullname);
    char defn[1024];
    snprintf(defn, 1024, "%s_surface_normal(%s)", 
                 (atts.GetCentering() == SurfaceNormalAttributes::Point ? "point" : "cell"),
                 varname.c_str());
    exp.SetDefinition(defn);
    exp.SetType(Expression::VectorMeshVar);
    elist.push_back(exp);
}


// ****************************************************************************
//  Method: avtSurfaceNormalFilter::GetVariableToEvaluated
//
//  Purpose:
//      Gets the expressions that should be evaluated when this filter
//      executes.
//
//  Programmer: Hank Childs
//  Creation:   September 24, 2010
//
// ****************************************************************************

void
avtSurfaceNormalFilter::GetVariablesToEvaluate(std::vector<std::string> &list)
{
    char fullname[1024];
    snprintf(fullname, 1024, "operators/SurfaceNormal/%s", varname.c_str());
    list.push_back(fullname);
}

// ****************************************************************************
// Method: avtSurfaceNormalFilter::UpdateDataObjectInfo
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtSurfaceNormalFilter::UpdateDataObjectInfo(void)
{
    avtPluginFilter::UpdateDataObjectInfo();
    avtDeferExpressionBaseFilter::UpdateDataObjectInfo();

    GetOutput()->GetInfo().GetAttributes().AddFilterMetaData("SurfaceNormal");
}
