// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfaceNormalPluginInfo.C
// ****************************************************************************

#include <SurfaceNormalPluginInfo.h>
#include <SurfaceNormalAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(SurfaceNormal,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(SurfaceNormal,General)

// ****************************************************************************
//  Method: SurfaceNormalGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceNormalGeneralPluginInfo::GetName() const
{
    return "SurfaceNormal";
}

// ****************************************************************************
//  Method: SurfaceNormalGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceNormalGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: SurfaceNormalGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceNormalGeneralPluginInfo::GetID() const
{
    return "SurfaceNormal_1.0";
}
// ****************************************************************************
//  Method: SurfaceNormalGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SurfaceNormalGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: SurfaceNormalGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceNormalGeneralPluginInfo::GetCategoryName() const
{
    return "Geometry";
}
