// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SURFACENORMALATTRIBUTES_H
#define SURFACENORMALATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SurfaceNormalAttributes
//
// Purpose:
//    Attributes for SurfaceNormal operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class SurfaceNormalAttributes : public AttributeSubject
{
public:
    enum Centering
    {
        Point,
        Cell
    };

    // These constructors are for objects of this class
    SurfaceNormalAttributes();
    SurfaceNormalAttributes(const SurfaceNormalAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SurfaceNormalAttributes(private_tmfs_t tmfs);
    SurfaceNormalAttributes(const SurfaceNormalAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SurfaceNormalAttributes();

    virtual SurfaceNormalAttributes& operator = (const SurfaceNormalAttributes &obj);
    virtual bool operator == (const SurfaceNormalAttributes &obj) const;
    virtual bool operator != (const SurfaceNormalAttributes &obj) const;
private:
    void Init();
    void Copy(const SurfaceNormalAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetCentering(Centering centering_);

    // Property getting methods
    Centering GetCentering() const;

    // Enum conversion functions
    static std::string Centering_ToString(Centering);
    static bool Centering_FromString(const std::string &, Centering &);
protected:
    static std::string Centering_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_centering = 0,
        ID__LAST
    };

private:
    int centering;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SURFACENORMALATTRIBUTES_TMFS "i"

#endif
