// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtSurfCompPrepFilter.h
// ************************************************************************* //

#ifndef AVT_SurfCompPrep_FILTER_H
#define AVT_SurfCompPrep_FILTER_H


#include <avtPluginFilter.h>
#include <avtDatasetToDatasetFilter.h>
#include <SurfCompPrepAttributes.h>


class vtkDataSet;


// ****************************************************************************
//  Class: avtSurfCompPrepFilter
//
//  Purpose:
//      A plugin operator for SurfCompPrep.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Jun 30 13:26:50 PST 2003
//
// ****************************************************************************

class avtSurfCompPrepFilter : virtual public avtPluginFilter,
                              virtual public avtDatasetToDatasetFilter
{
  public:
                         avtSurfCompPrepFilter();
    virtual             ~avtSurfCompPrepFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtSurfCompPrepFilter"; };
    virtual const char  *GetDescription(void)
                             { return "SurfCompPrep"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    SurfCompPrepAttributes   atts;

    virtual void          Execute(void);
    virtual void          UpdateDataObjectInfo(void);
    virtual int           AdditionalPipelineFilters(void);
};


#endif
