// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfCompPrepViewerEnginePluginInfo.C
// ****************************************************************************

#include <SurfCompPrepPluginInfo.h>
#include <SurfCompPrepAttributes.h>

//
// Storage for static data elements.
//
SurfCompPrepAttributes *SurfCompPrepViewerEnginePluginInfo::clientAtts = NULL;
SurfCompPrepAttributes *SurfCompPrepViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SurfCompPrepViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
SurfCompPrepViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (SurfCompPrepViewerEnginePluginInfo::clientAtts == NULL)
    {
        SurfCompPrepViewerEnginePluginInfo::clientAtts  = new SurfCompPrepAttributes;
        SurfCompPrepViewerEnginePluginInfo::defaultAtts = new SurfCompPrepAttributes;
    }
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfCompPrepViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfCompPrepViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfCompPrepViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SurfCompPrepAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfCompPrepViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SurfCompPrepAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfCompPrepViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SurfCompPrepAttributes*)atts = *defaultAtts;
    else
        *(SurfCompPrepAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfCompPrepViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: SurfCompPrepViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfCompPrepViewerEnginePluginInfo::GetMenuName() const
{
    return "SurfCompPrep";
}

