// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfCompPrepGUIPluginInfo.C
// ****************************************************************************

#include <SurfCompPrepPluginInfo.h>
#include <SurfCompPrepAttributes.h>
#include <QApplication>
#include <QvisSurfCompPrepWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SurfCompPrep,GUI)

// ****************************************************************************
//  Method: SurfCompPrepGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
SurfCompPrepGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "SurfCompPrep"));
}


// ****************************************************************************
//  Method: SurfCompPrepGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
SurfCompPrepGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisSurfCompPrepWindow(type, (SurfCompPrepAttributes *)attr,
        caption, shortName, notepad);
}

