// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PySurfCompPrepAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PySurfCompPrepAttributes
//
// Purpose:
//   Attributes for the SurfCompPrep operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SurfCompPrepAttributes.
//
struct SurfCompPrepAttributesObject
{
    PyObject_HEAD
    SurfCompPrepAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSurfCompPrepAttributes(int);

std::string
PySurfCompPrepAttributes_ToString(const SurfCompPrepAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *surfaceType_names = "Closest, Farthest, Average";
    switch (atts->GetSurfaceType())
    {
      case SurfCompPrepAttributes::Closest:
          snprintf(tmpStr, 1000, "%ssurfaceType = %sClosest  # %s\n", prefix, prefix, surfaceType_names);
          str += tmpStr;
          break;
      case SurfCompPrepAttributes::Farthest:
          snprintf(tmpStr, 1000, "%ssurfaceType = %sFarthest  # %s\n", prefix, prefix, surfaceType_names);
          str += tmpStr;
          break;
      case SurfCompPrepAttributes::Average:
          snprintf(tmpStr, 1000, "%ssurfaceType = %sAverage  # %s\n", prefix, prefix, surfaceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *coordSystem_names = "Cartesian, Cylindrical, Spherical";
    switch (atts->GetCoordSystem())
    {
      case SurfCompPrepAttributes::Cartesian:
          snprintf(tmpStr, 1000, "%scoordSystem = %sCartesian  # %s\n", prefix, prefix, coordSystem_names);
          str += tmpStr;
          break;
      case SurfCompPrepAttributes::Cylindrical:
          snprintf(tmpStr, 1000, "%scoordSystem = %sCylindrical  # %s\n", prefix, prefix, coordSystem_names);
          str += tmpStr;
          break;
      case SurfCompPrepAttributes::Spherical:
          snprintf(tmpStr, 1000, "%scoordSystem = %sSpherical  # %s\n", prefix, prefix, coordSystem_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sthetaStart = %g\n", prefix, atts->GetThetaStart());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sthetaStop = %g\n", prefix, atts->GetThetaStop());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sthetaSteps = %d\n", prefix, atts->GetThetaSteps());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sphiStart = %g\n", prefix, atts->GetPhiStart());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sphiStop = %g\n", prefix, atts->GetPhiStop());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sphiSteps = %d\n", prefix, atts->GetPhiSteps());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sstartRadius = %g\n", prefix, atts->GetStartRadius());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sendRadius = %g\n", prefix, atts->GetEndRadius());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sradiusSteps = %d\n", prefix, atts->GetRadiusSteps());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sxStart = %g\n", prefix, atts->GetXStart());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sxStop = %g\n", prefix, atts->GetXStop());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sxSteps = %d\n", prefix, atts->GetXSteps());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%syStart = %g\n", prefix, atts->GetYStart());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%syStop = %g\n", prefix, atts->GetYStop());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sySteps = %d\n", prefix, atts->GetYSteps());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%szStart = %g\n", prefix, atts->GetZStart());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%szStop = %g\n", prefix, atts->GetZStop());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%szSteps = %d\n", prefix, atts->GetZSteps());
    str += tmpStr;
    return str;
}

static PyObject *
SurfCompPrepAttributes_Notify(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetSurfaceType(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the surfaceType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSurfaceType(SurfCompPrepAttributes::SurfaceType(ival));
    else
    {
        fprintf(stderr, "An invalid surfaceType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Closest, Farthest, Average.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetSurfaceType(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSurfaceType()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetCoordSystem(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the coordSystem in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCoordSystem(SurfCompPrepAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid coordSystem value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetCoordSystem(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCoordSystem()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetThetaStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the thetaStart in the object.
    obj->data->SetThetaStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetThetaStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThetaStart());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetThetaStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the thetaStop in the object.
    obj->data->SetThetaStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetThetaStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThetaStop());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetThetaSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the thetaSteps in the object.
    obj->data->SetThetaSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetThetaSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetThetaSteps()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetPhiStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the phiStart in the object.
    obj->data->SetPhiStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetPhiStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPhiStart());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetPhiStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the phiStop in the object.
    obj->data->SetPhiStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetPhiStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPhiStop());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetPhiSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the phiSteps in the object.
    obj->data->SetPhiSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetPhiSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPhiSteps()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetStartRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startRadius in the object.
    obj->data->SetStartRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetStartRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartRadius());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetEndRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endRadius in the object.
    obj->data->SetEndRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetEndRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndRadius());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetRadiusSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the radiusSteps in the object.
    obj->data->SetRadiusSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetRadiusSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRadiusSteps()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetXStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xStart in the object.
    obj->data->SetXStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetXStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXStart());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetXStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xStop in the object.
    obj->data->SetXStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetXStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXStop());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetXSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xSteps in the object.
    obj->data->SetXSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetXSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXSteps()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetYStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yStart in the object.
    obj->data->SetYStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetYStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYStart());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetYStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yStop in the object.
    obj->data->SetYStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetYStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYStop());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetYSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ySteps in the object.
    obj->data->SetYSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetYSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYSteps()));
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetZStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zStart in the object.
    obj->data->SetZStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetZStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZStart());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetZStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zStop in the object.
    obj->data->SetZStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetZStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZStop());
    return retval;
}

/*static*/ PyObject *
SurfCompPrepAttributes_SetZSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zSteps in the object.
    obj->data->SetZSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfCompPrepAttributes_GetZSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZSteps()));
    return retval;
}



PyMethodDef PySurfCompPrepAttributes_methods[SURFCOMPPREPATTRIBUTES_NMETH] = {
    {"Notify", SurfCompPrepAttributes_Notify, METH_VARARGS},
    {"SetSurfaceType", SurfCompPrepAttributes_SetSurfaceType, METH_VARARGS},
    {"GetSurfaceType", SurfCompPrepAttributes_GetSurfaceType, METH_VARARGS},
    {"SetCoordSystem", SurfCompPrepAttributes_SetCoordSystem, METH_VARARGS},
    {"GetCoordSystem", SurfCompPrepAttributes_GetCoordSystem, METH_VARARGS},
    {"SetThetaStart", SurfCompPrepAttributes_SetThetaStart, METH_VARARGS},
    {"GetThetaStart", SurfCompPrepAttributes_GetThetaStart, METH_VARARGS},
    {"SetThetaStop", SurfCompPrepAttributes_SetThetaStop, METH_VARARGS},
    {"GetThetaStop", SurfCompPrepAttributes_GetThetaStop, METH_VARARGS},
    {"SetThetaSteps", SurfCompPrepAttributes_SetThetaSteps, METH_VARARGS},
    {"GetThetaSteps", SurfCompPrepAttributes_GetThetaSteps, METH_VARARGS},
    {"SetPhiStart", SurfCompPrepAttributes_SetPhiStart, METH_VARARGS},
    {"GetPhiStart", SurfCompPrepAttributes_GetPhiStart, METH_VARARGS},
    {"SetPhiStop", SurfCompPrepAttributes_SetPhiStop, METH_VARARGS},
    {"GetPhiStop", SurfCompPrepAttributes_GetPhiStop, METH_VARARGS},
    {"SetPhiSteps", SurfCompPrepAttributes_SetPhiSteps, METH_VARARGS},
    {"GetPhiSteps", SurfCompPrepAttributes_GetPhiSteps, METH_VARARGS},
    {"SetStartRadius", SurfCompPrepAttributes_SetStartRadius, METH_VARARGS},
    {"GetStartRadius", SurfCompPrepAttributes_GetStartRadius, METH_VARARGS},
    {"SetEndRadius", SurfCompPrepAttributes_SetEndRadius, METH_VARARGS},
    {"GetEndRadius", SurfCompPrepAttributes_GetEndRadius, METH_VARARGS},
    {"SetRadiusSteps", SurfCompPrepAttributes_SetRadiusSteps, METH_VARARGS},
    {"GetRadiusSteps", SurfCompPrepAttributes_GetRadiusSteps, METH_VARARGS},
    {"SetXStart", SurfCompPrepAttributes_SetXStart, METH_VARARGS},
    {"GetXStart", SurfCompPrepAttributes_GetXStart, METH_VARARGS},
    {"SetXStop", SurfCompPrepAttributes_SetXStop, METH_VARARGS},
    {"GetXStop", SurfCompPrepAttributes_GetXStop, METH_VARARGS},
    {"SetXSteps", SurfCompPrepAttributes_SetXSteps, METH_VARARGS},
    {"GetXSteps", SurfCompPrepAttributes_GetXSteps, METH_VARARGS},
    {"SetYStart", SurfCompPrepAttributes_SetYStart, METH_VARARGS},
    {"GetYStart", SurfCompPrepAttributes_GetYStart, METH_VARARGS},
    {"SetYStop", SurfCompPrepAttributes_SetYStop, METH_VARARGS},
    {"GetYStop", SurfCompPrepAttributes_GetYStop, METH_VARARGS},
    {"SetYSteps", SurfCompPrepAttributes_SetYSteps, METH_VARARGS},
    {"GetYSteps", SurfCompPrepAttributes_GetYSteps, METH_VARARGS},
    {"SetZStart", SurfCompPrepAttributes_SetZStart, METH_VARARGS},
    {"GetZStart", SurfCompPrepAttributes_GetZStart, METH_VARARGS},
    {"SetZStop", SurfCompPrepAttributes_SetZStop, METH_VARARGS},
    {"GetZStop", SurfCompPrepAttributes_GetZStop, METH_VARARGS},
    {"SetZSteps", SurfCompPrepAttributes_SetZSteps, METH_VARARGS},
    {"GetZSteps", SurfCompPrepAttributes_GetZSteps, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SurfCompPrepAttributes_dealloc(PyObject *v)
{
   SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SurfCompPrepAttributes_compare(PyObject *v, PyObject *w)
{
    SurfCompPrepAttributes *a = ((SurfCompPrepAttributesObject *)v)->data;
    SurfCompPrepAttributes *b = ((SurfCompPrepAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySurfCompPrepAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "surfaceType") == 0)
        return SurfCompPrepAttributes_GetSurfaceType(self, NULL);
    if(strcmp(name, "Closest") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Closest));
    if(strcmp(name, "Farthest") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Farthest));
    if(strcmp(name, "Average") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Average));

    if(strcmp(name, "coordSystem") == 0)
        return SurfCompPrepAttributes_GetCoordSystem(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Cylindrical));
    if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Spherical));

    if(strcmp(name, "thetaStart") == 0)
        return SurfCompPrepAttributes_GetThetaStart(self, NULL);
    if(strcmp(name, "thetaStop") == 0)
        return SurfCompPrepAttributes_GetThetaStop(self, NULL);
    if(strcmp(name, "thetaSteps") == 0)
        return SurfCompPrepAttributes_GetThetaSteps(self, NULL);
    if(strcmp(name, "phiStart") == 0)
        return SurfCompPrepAttributes_GetPhiStart(self, NULL);
    if(strcmp(name, "phiStop") == 0)
        return SurfCompPrepAttributes_GetPhiStop(self, NULL);
    if(strcmp(name, "phiSteps") == 0)
        return SurfCompPrepAttributes_GetPhiSteps(self, NULL);
    if(strcmp(name, "startRadius") == 0)
        return SurfCompPrepAttributes_GetStartRadius(self, NULL);
    if(strcmp(name, "endRadius") == 0)
        return SurfCompPrepAttributes_GetEndRadius(self, NULL);
    if(strcmp(name, "radiusSteps") == 0)
        return SurfCompPrepAttributes_GetRadiusSteps(self, NULL);
    if(strcmp(name, "xStart") == 0)
        return SurfCompPrepAttributes_GetXStart(self, NULL);
    if(strcmp(name, "xStop") == 0)
        return SurfCompPrepAttributes_GetXStop(self, NULL);
    if(strcmp(name, "xSteps") == 0)
        return SurfCompPrepAttributes_GetXSteps(self, NULL);
    if(strcmp(name, "yStart") == 0)
        return SurfCompPrepAttributes_GetYStart(self, NULL);
    if(strcmp(name, "yStop") == 0)
        return SurfCompPrepAttributes_GetYStop(self, NULL);
    if(strcmp(name, "ySteps") == 0)
        return SurfCompPrepAttributes_GetYSteps(self, NULL);
    if(strcmp(name, "zStart") == 0)
        return SurfCompPrepAttributes_GetZStart(self, NULL);
    if(strcmp(name, "zStop") == 0)
        return SurfCompPrepAttributes_GetZStop(self, NULL);
    if(strcmp(name, "zSteps") == 0)
        return SurfCompPrepAttributes_GetZSteps(self, NULL);

    return Py_FindMethod(PySurfCompPrepAttributes_methods, self, name);
}

int
PySurfCompPrepAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "surfaceType") == 0)
        obj = SurfCompPrepAttributes_SetSurfaceType(self, tuple);
    else if(strcmp(name, "coordSystem") == 0)
        obj = SurfCompPrepAttributes_SetCoordSystem(self, tuple);
    else if(strcmp(name, "thetaStart") == 0)
        obj = SurfCompPrepAttributes_SetThetaStart(self, tuple);
    else if(strcmp(name, "thetaStop") == 0)
        obj = SurfCompPrepAttributes_SetThetaStop(self, tuple);
    else if(strcmp(name, "thetaSteps") == 0)
        obj = SurfCompPrepAttributes_SetThetaSteps(self, tuple);
    else if(strcmp(name, "phiStart") == 0)
        obj = SurfCompPrepAttributes_SetPhiStart(self, tuple);
    else if(strcmp(name, "phiStop") == 0)
        obj = SurfCompPrepAttributes_SetPhiStop(self, tuple);
    else if(strcmp(name, "phiSteps") == 0)
        obj = SurfCompPrepAttributes_SetPhiSteps(self, tuple);
    else if(strcmp(name, "startRadius") == 0)
        obj = SurfCompPrepAttributes_SetStartRadius(self, tuple);
    else if(strcmp(name, "endRadius") == 0)
        obj = SurfCompPrepAttributes_SetEndRadius(self, tuple);
    else if(strcmp(name, "radiusSteps") == 0)
        obj = SurfCompPrepAttributes_SetRadiusSteps(self, tuple);
    else if(strcmp(name, "xStart") == 0)
        obj = SurfCompPrepAttributes_SetXStart(self, tuple);
    else if(strcmp(name, "xStop") == 0)
        obj = SurfCompPrepAttributes_SetXStop(self, tuple);
    else if(strcmp(name, "xSteps") == 0)
        obj = SurfCompPrepAttributes_SetXSteps(self, tuple);
    else if(strcmp(name, "yStart") == 0)
        obj = SurfCompPrepAttributes_SetYStart(self, tuple);
    else if(strcmp(name, "yStop") == 0)
        obj = SurfCompPrepAttributes_SetYStop(self, tuple);
    else if(strcmp(name, "ySteps") == 0)
        obj = SurfCompPrepAttributes_SetYSteps(self, tuple);
    else if(strcmp(name, "zStart") == 0)
        obj = SurfCompPrepAttributes_SetZStart(self, tuple);
    else if(strcmp(name, "zStop") == 0)
        obj = SurfCompPrepAttributes_SetZStop(self, tuple);
    else if(strcmp(name, "zSteps") == 0)
        obj = SurfCompPrepAttributes_SetZSteps(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SurfCompPrepAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)v;
    fprintf(fp, "%s", PySurfCompPrepAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SurfCompPrepAttributes_str(PyObject *v)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)v;
    return PyString_FromString(PySurfCompPrepAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SurfCompPrepAttributes_Purpose = "Attributes for the SurfCompPrep operator.";
#else
static char *SurfCompPrepAttributes_Purpose = "Attributes for the SurfCompPrep operator.";
#endif

//
// The type description structure
//
static PyTypeObject SurfCompPrepAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SurfCompPrepAttributes",                    // tp_name
    sizeof(SurfCompPrepAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SurfCompPrepAttributes_dealloc,  // tp_dealloc
    (printfunc)SurfCompPrepAttributes_print,     // tp_print
    (getattrfunc)PySurfCompPrepAttributes_getattr, // tp_getattr
    (setattrfunc)PySurfCompPrepAttributes_setattr, // tp_setattr
    (cmpfunc)SurfCompPrepAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SurfCompPrepAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SurfCompPrepAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SurfCompPrepAttributes *defaultAtts = 0;
static SurfCompPrepAttributes *currentAtts = 0;

static PyObject *
NewSurfCompPrepAttributes(int useCurrent)
{
    SurfCompPrepAttributesObject *newObject;
    newObject = PyObject_NEW(SurfCompPrepAttributesObject, &SurfCompPrepAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SurfCompPrepAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SurfCompPrepAttributes(*defaultAtts);
    else
        newObject->data = new SurfCompPrepAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSurfCompPrepAttributes(const SurfCompPrepAttributes *attr)
{
    SurfCompPrepAttributesObject *newObject;
    newObject = PyObject_NEW(SurfCompPrepAttributesObject, &SurfCompPrepAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SurfCompPrepAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SurfCompPrepAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSurfCompPrepAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SurfCompPrepAttributesMethods[] = {
    {"SurfCompPrepAttributes", SurfCompPrepAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SurfCompPrepAttributesObserver = 0;

std::string
PySurfCompPrepAttributes_GetLogString()
{
    std::string s("SurfCompPrepAtts = SurfCompPrepAttributes()\n");
    if(currentAtts != 0)
        s += PySurfCompPrepAttributes_ToString(currentAtts, "SurfCompPrepAtts.");
    return s;
}

static void
PySurfCompPrepAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SurfCompPrepAtts = SurfCompPrepAttributes()\n");
        s += PySurfCompPrepAttributes_ToString(currentAtts, "SurfCompPrepAtts.");
        cb(s);
    }
}

void
PySurfCompPrepAttributes_StartUp(SurfCompPrepAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySurfCompPrepAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SurfCompPrepAttributesObserver == 0)
    {
        SurfCompPrepAttributesObserver = new ObserverToCallback(subj,
            PySurfCompPrepAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySurfCompPrepAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SurfCompPrepAttributesObserver;
    SurfCompPrepAttributesObserver = 0;
}

PyMethodDef *
PySurfCompPrepAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SurfCompPrepAttributesMethods;
}

bool
PySurfCompPrepAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SurfCompPrepAttributesType);
}

SurfCompPrepAttributes *
PySurfCompPrepAttributes_FromPyObject(PyObject *obj)
{
    SurfCompPrepAttributesObject *obj2 = (SurfCompPrepAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySurfCompPrepAttributes_New()
{
    return NewSurfCompPrepAttributes(0);
}

PyObject *
PySurfCompPrepAttributes_Wrap(const SurfCompPrepAttributes *attr)
{
    return WrapSurfCompPrepAttributes(attr);
}

void
PySurfCompPrepAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SurfCompPrepAttributesObject *obj2 = (SurfCompPrepAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySurfCompPrepAttributes_SetDefaults(const SurfCompPrepAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SurfCompPrepAttributes(*atts);
}

