// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtSubdivideQuadsFilter.h
// ************************************************************************* //

#ifndef AVT_SubdivideQuads_FILTER_H
#define AVT_SubdivideQuads_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <SubdivideQuadsAttributes.h>


// ****************************************************************************
//  Class: avtSubdivideQuadsFilter
//
//  Purpose:
//      This operator will subdivide quadrilaterals based on a threshold
//      criteria.  The threshold is based on the maximum allowable change in 
//      variable value in a quad (so this operator really only makes sense for
//      nodal variables).  The point is to subdivide to the point that we 
//      aren't at the mercy of graphics hardware/rasterization techniques when
//      we are looking at only a handful of zones and those zones have a large
//      change in scalar value/color.
//
//  Note: the purpose of this operator is to subdivide quads using bilinear
//        interpolation because graphics rasterization does such a bad job.
//        Triangles are correctly interpolated, so this isn't a big deal.
//        That said, interpolation happens in color space, not data space.
//        So there is an option to subdivide triangles as well, because color
//        space interpolations can be deceiving.  Note that this option would
//        be totally worthless if we used textures instead.
//
//  Note: the edge connectivity of the surface after the application of this
//        operator will be poor (ie lots of T-intersections).
//        There is an option to take the points that are candidates to be
//        at T-intersections and move them away from the quad center, creating
//        overlapping quads.  This at least prevents artifacts where there are
//        "flashing holes" in your surface.  It can, however, lead to problems
//        where there is z-buffer fighting.  In practice, however, this isn't
//        too bad since the two quads fighting in z-buffer space typically
//        have very similar values.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue Nov 2 05:54:25 PDT 2004
//
//  Modifications:
//    Eric Brugger, Tue Aug 19 09:22:04 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtSubdivideQuadsFilter : public avtPluginDataTreeIterator
{
  public:
                         avtSubdivideQuadsFilter();
    virtual             ~avtSubdivideQuadsFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtSubdivideQuadsFilter"; };
    virtual const char  *GetDescription(void)
                             { return "SubdivideQuads"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    SubdivideQuadsAttributes   atts;
    bool                       haveIssuedWarning;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
};


#endif
