// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SubdivideQuadsPluginInfo.h
// ****************************************************************************

#ifndef SUBDIVIDEQUADS_PLUGIN_INFO_H
#define SUBDIVIDEQUADS_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class SubdivideQuadsAttributes;

// ****************************************************************************
//  Class: SubdivideQuadsPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an SubdivideQuads operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class SubdivideQuadsGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class SubdivideQuadsCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual SubdivideQuadsGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class SubdivideQuadsGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual SubdivideQuadsCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class SubdivideQuadsViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual SubdivideQuadsCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static SubdivideQuadsAttributes *defaultAtts;
    static SubdivideQuadsAttributes *clientAtts;
};

class SubdivideQuadsViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual SubdivideQuadsViewerEnginePluginInfo
{
  public:
};

class SubdivideQuadsEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual SubdivideQuadsViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class SubdivideQuadsScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual SubdivideQuadsCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
