// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisSubdivideQuadsWindow.h"

#include <SubdivideQuadsAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisSubdivideQuadsWindow::QvisSubdivideQuadsWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSubdivideQuadsWindow::QvisSubdivideQuadsWindow(const int type,
                         SubdivideQuadsAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisSubdivideQuadsWindow::~QvisSubdivideQuadsWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSubdivideQuadsWindow::~QvisSubdivideQuadsWindow()
{
}


// ****************************************************************************
// Method: QvisSubdivideQuadsWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSubdivideQuadsWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    thresholdLabel = new QLabel(tr("Biggest change allowed in a zone?"), central);
    mainLayout->addWidget(thresholdLabel,0,0);
    threshold = new QLineEdit(central);
    connect(threshold, SIGNAL(returnPressed()),
            this, SLOT(thresholdProcessText()));
    mainLayout->addWidget(threshold, 0,1);

    maxSubdivsLabel = new QLabel(tr("Maximum number of subdivisions"), central);
    mainLayout->addWidget(maxSubdivsLabel,1,0);
    maxSubdivs = new QLineEdit(central);
    connect(maxSubdivs, SIGNAL(returnPressed()),
            this, SLOT(maxSubdivsProcessText()));
    mainLayout->addWidget(maxSubdivs, 1,1);

    fanOutPoints = new QCheckBox(tr("Fan out points to cover up T-intersections?"), central);
    connect(fanOutPoints, SIGNAL(toggled(bool)),
            this, SLOT(fanOutPointsChanged(bool)));
    mainLayout->addWidget(fanOutPoints, 2,0);

    doTriangles = new QCheckBox(tr("Subdivide triangles"), central);
    connect(doTriangles, SIGNAL(toggled(bool)),
            this, SLOT(doTrianglesChanged(bool)));
    mainLayout->addWidget(doTriangles, 3,0);

    variableLabel = new QLabel(tr("Variable to base subdivision on"), central);
    mainLayout->addWidget(variableLabel,4,0);
    int variableMask = QvisVariableButton::Scalars;
    variable = new QvisVariableButton(true, true, true, variableMask, central);
    connect(variable, SIGNAL(activated(const QString&)),
            this, SLOT(variableChanged(const QString&)));
    mainLayout->addWidget(variable, 4,1);

}


// ****************************************************************************
// Method: QvisSubdivideQuadsWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSubdivideQuadsWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case SubdivideQuadsAttributes::ID_threshold:
            threshold->setText(DoubleToQString(atts->GetThreshold()));
            break;
          case SubdivideQuadsAttributes::ID_maxSubdivs:
            maxSubdivs->setText(IntToQString(atts->GetMaxSubdivs()));
            break;
          case SubdivideQuadsAttributes::ID_fanOutPoints:
            fanOutPoints->blockSignals(true);
            fanOutPoints->setChecked(atts->GetFanOutPoints());
            fanOutPoints->blockSignals(false);
            break;
          case SubdivideQuadsAttributes::ID_doTriangles:
            doTriangles->blockSignals(true);
            doTriangles->setChecked(atts->GetDoTriangles());
            doTriangles->blockSignals(false);
            break;
          case SubdivideQuadsAttributes::ID_variable:
            variable->blockSignals(true);
            variable->setText(QString(atts->GetVariable().c_str()));
            variable->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisSubdivideQuadsWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSubdivideQuadsWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do threshold
    if(which_widget == SubdivideQuadsAttributes::ID_threshold || doAll)
    {
        double val;
        if(LineEditGetDouble(threshold, val))
            atts->SetThreshold(val);
        else
        {
            ResettingError(tr("Biggest change allowed in a zone?"),
                DoubleToQString(atts->GetThreshold()));
            atts->SetThreshold(atts->GetThreshold());
        }
    }

    // Do maxSubdivs
    if(which_widget == SubdivideQuadsAttributes::ID_maxSubdivs || doAll)
    {
        int val;
        if(LineEditGetInt(maxSubdivs, val))
            atts->SetMaxSubdivs(val);
        else
        {
            ResettingError(tr("Maximum number of subdivisions"),
                IntToQString(atts->GetMaxSubdivs()));
            atts->SetMaxSubdivs(atts->GetMaxSubdivs());
        }
    }

}


//
// Qt Slot functions
//


void
QvisSubdivideQuadsWindow::thresholdProcessText()
{
    GetCurrentValues(SubdivideQuadsAttributes::ID_threshold);
    Apply();
}


void
QvisSubdivideQuadsWindow::maxSubdivsProcessText()
{
    GetCurrentValues(SubdivideQuadsAttributes::ID_maxSubdivs);
    Apply();
}


void
QvisSubdivideQuadsWindow::fanOutPointsChanged(bool val)
{
    atts->SetFanOutPoints(val);
    SetUpdate(false);
    Apply();
}


void
QvisSubdivideQuadsWindow::doTrianglesChanged(bool val)
{
    atts->SetDoTriangles(val);
    SetUpdate(false);
    Apply();
}


void
QvisSubdivideQuadsWindow::variableChanged(const QString &varName)
{
    atts->SetVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


