// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtStatisticalTrendsFilter.h
// ************************************************************************* //

#ifndef AVT_STATISTICALTRENDS_FILTER_H
#define AVT_STATISTICALTRENDS_FILTER_H

//#include <avtPluginDataTreeIterator.h>
#include <avtPluginFilter.h>
#include <avtTimeLoopFilter.h>
#include <avtDatasetToDatasetFilter.h>

#include <avtExtents.h>

#include <StatisticalTrendsAttributes.h>

class vtkDataSet;

// ****************************************************************************
//  Class: avtStatisticalTrendsFilter
//
//  Purpose:
//      A plugin operator for StatisticalTrends. This operator traces 
//      a set of particles based on a given ID variable through time. The
//      operator iterates through the time series and connects the locations
//      of the given particles to compute theit trend. The operator creates
//      a new vtkUnstructuredGrid dataset with the pahts as output.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Fri Jan 25 11:02:55 PDT 2008
//
// ****************************************************************************

class avtStatisticalTrendsFilter : virtual public avtPluginFilter,
                                   virtual public avtTimeLoopFilter,
                                   virtual public avtDatasetToDatasetFilter
{
  public:
                         avtStatisticalTrendsFilter();
    virtual             ~avtStatisticalTrendsFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtStatisticalTrendsFilter"; };
    virtual const char  *GetDescription(void)
                             { return "StatisticalTrends"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    StatisticalTrendsAttributes atts;

    virtual void InitializeTimeLoop(void);

    virtual void ExamineContract(avtContract_p in_contract);
    virtual void UpdateDataObjectInfo();

    virtual avtContract_p ModifyContract(avtContract_p in_spec);
    virtual void Execute(void);
    virtual void CreateFinalOutput(void);
    virtual bool ExecutionSuccessful(void);

  protected:
    std::vector< vtkDataSet* > trend_ds;

    vtkDataSet *sumX_ds, *sumY_ds, *sumX2_ds, *sumY2_ds, *sumXY_ds,
       *slope_ds, *intercept_ds, *out_ds;

    std::string outVarName;

    bool validTimeAxis;
    double lastTimeAxisValue;

    std::string mainVariable;   
    bool haveData;

    int numTypes;
    char typeString[6][12];
};
#endif
