// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef STATISTICALTRENDSATTRIBUTES_H
#define STATISTICALTRENDSATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: StatisticalTrendsAttributes
//
// Purpose:
//    This class contains attributes for the StatisticalTrends operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class StatisticalTrendsAttributes : public AttributeSubject
{
public:
    enum TrendTypeEnum
    {
        Absolute,
        Relative
    };
    enum StatisticTypeEnum
    {
        Sum,
        Mean,
        Variance,
        StandardDeviation,
        Slope,
        Residuals
    };
    enum TrendAxisEnum
    {
        Step,
        Time,
        Cycle
    };
    enum VariableSourceEnum
    {
        Default,
        OperatorExpression
    };

    // These constructors are for objects of this class
    StatisticalTrendsAttributes();
    StatisticalTrendsAttributes(const StatisticalTrendsAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    StatisticalTrendsAttributes(private_tmfs_t tmfs);
    StatisticalTrendsAttributes(const StatisticalTrendsAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~StatisticalTrendsAttributes();

    virtual StatisticalTrendsAttributes& operator = (const StatisticalTrendsAttributes &obj);
    virtual bool operator == (const StatisticalTrendsAttributes &obj) const;
    virtual bool operator != (const StatisticalTrendsAttributes &obj) const;
private:
    void Init();
    void Copy(const StatisticalTrendsAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetStartIndex(int startIndex_);
    void SetStopIndex(int stopIndex_);
    void SetStride(int stride_);
    void SetStartTrendType(TrendTypeEnum startTrendType_);
    void SetStopTrendType(TrendTypeEnum stopTrendType_);
    void SetStatisticType(StatisticTypeEnum statisticType_);
    void SetTrendAxis(TrendAxisEnum trendAxis_);
    void SetVariableSource(VariableSourceEnum variableSource_);

    // Property getting methods
    int GetStartIndex() const;
    int GetStopIndex() const;
    int GetStride() const;
    TrendTypeEnum GetStartTrendType() const;
    TrendTypeEnum GetStopTrendType() const;
    StatisticTypeEnum GetStatisticType() const;
    TrendAxisEnum GetTrendAxis() const;
    VariableSourceEnum GetVariableSource() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string TrendTypeEnum_ToString(TrendTypeEnum);
    static bool TrendTypeEnum_FromString(const std::string &, TrendTypeEnum &);
protected:
    static std::string TrendTypeEnum_ToString(int);
public:
    static std::string StatisticTypeEnum_ToString(StatisticTypeEnum);
    static bool StatisticTypeEnum_FromString(const std::string &, StatisticTypeEnum &);
protected:
    static std::string StatisticTypeEnum_ToString(int);
public:
    static std::string TrendAxisEnum_ToString(TrendAxisEnum);
    static bool TrendAxisEnum_FromString(const std::string &, TrendAxisEnum &);
protected:
    static std::string TrendAxisEnum_ToString(int);
public:
    static std::string VariableSourceEnum_ToString(VariableSourceEnum);
    static bool VariableSourceEnum_FromString(const std::string &, VariableSourceEnum &);
protected:
    static std::string VariableSourceEnum_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_startIndex = 0,
        ID_stopIndex,
        ID_stride,
        ID_startTrendType,
        ID_stopTrendType,
        ID_statisticType,
        ID_trendAxis,
        ID_variableSource,
        ID__LAST
    };

private:
    int startIndex;
    int stopIndex;
    int stride;
    int startTrendType;
    int stopTrendType;
    int statisticType;
    int trendAxis;
    int variableSource;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define STATISTICALTRENDSATTRIBUTES_TMFS "iiiiiiii"

#endif
