// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyStatisticalTrendsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyStatisticalTrendsAttributes
//
// Purpose:
//   This class contains attributes for the StatisticalTrends operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a StatisticalTrendsAttributes.
//
struct StatisticalTrendsAttributesObject
{
    PyObject_HEAD
    StatisticalTrendsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewStatisticalTrendsAttributes(int);

std::string
PyStatisticalTrendsAttributes_ToString(const StatisticalTrendsAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sstartIndex = %d\n", prefix, atts->GetStartIndex());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sstopIndex = %d\n", prefix, atts->GetStopIndex());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sstride = %d\n", prefix, atts->GetStride());
    str += tmpStr;
    const char *startTrendType_names = "Absolute, Relative";
    switch (atts->GetStartTrendType())
    {
      case StatisticalTrendsAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sstartTrendType = %sAbsolute  # %s\n", prefix, prefix, startTrendType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Relative:
          snprintf(tmpStr, 1000, "%sstartTrendType = %sRelative  # %s\n", prefix, prefix, startTrendType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *stopTrendType_names = "Absolute, Relative";
    switch (atts->GetStopTrendType())
    {
      case StatisticalTrendsAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sstopTrendType = %sAbsolute  # %s\n", prefix, prefix, stopTrendType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Relative:
          snprintf(tmpStr, 1000, "%sstopTrendType = %sRelative  # %s\n", prefix, prefix, stopTrendType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *statisticType_names = "Sum, Mean, Variance, StandardDeviation, Slope, "
        "Residuals";
    switch (atts->GetStatisticType())
    {
      case StatisticalTrendsAttributes::Sum:
          snprintf(tmpStr, 1000, "%sstatisticType = %sSum  # %s\n", prefix, prefix, statisticType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Mean:
          snprintf(tmpStr, 1000, "%sstatisticType = %sMean  # %s\n", prefix, prefix, statisticType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Variance:
          snprintf(tmpStr, 1000, "%sstatisticType = %sVariance  # %s\n", prefix, prefix, statisticType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::StandardDeviation:
          snprintf(tmpStr, 1000, "%sstatisticType = %sStandardDeviation  # %s\n", prefix, prefix, statisticType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Slope:
          snprintf(tmpStr, 1000, "%sstatisticType = %sSlope  # %s\n", prefix, prefix, statisticType_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Residuals:
          snprintf(tmpStr, 1000, "%sstatisticType = %sResiduals  # %s\n", prefix, prefix, statisticType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *trendAxis_names = "Step, Time, Cycle";
    switch (atts->GetTrendAxis())
    {
      case StatisticalTrendsAttributes::Step:
          snprintf(tmpStr, 1000, "%strendAxis = %sStep  # %s\n", prefix, prefix, trendAxis_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Time:
          snprintf(tmpStr, 1000, "%strendAxis = %sTime  # %s\n", prefix, prefix, trendAxis_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::Cycle:
          snprintf(tmpStr, 1000, "%strendAxis = %sCycle  # %s\n", prefix, prefix, trendAxis_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *variableSource_names = "Default, OperatorExpression";
    switch (atts->GetVariableSource())
    {
      case StatisticalTrendsAttributes::Default:
          snprintf(tmpStr, 1000, "%svariableSource = %sDefault  # %s\n", prefix, prefix, variableSource_names);
          str += tmpStr;
          break;
      case StatisticalTrendsAttributes::OperatorExpression:
          snprintf(tmpStr, 1000, "%svariableSource = %sOperatorExpression  # %s\n", prefix, prefix, variableSource_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
StatisticalTrendsAttributes_Notify(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetStartIndex(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startIndex in the object.
    obj->data->SetStartIndex((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetStartIndex(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartIndex()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetStopIndex(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stopIndex in the object.
    obj->data->SetStopIndex((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetStopIndex(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStopIndex()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetStride(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetStride(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetStartTrendType(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startTrendType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetStartTrendType(StatisticalTrendsAttributes::TrendTypeEnum(ival));
    else
    {
        fprintf(stderr, "An invalid startTrendType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, Relative.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetStartTrendType(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartTrendType()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetStopTrendType(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stopTrendType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetStopTrendType(StatisticalTrendsAttributes::TrendTypeEnum(ival));
    else
    {
        fprintf(stderr, "An invalid stopTrendType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, Relative.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetStopTrendType(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStopTrendType()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetStatisticType(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the statisticType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetStatisticType(StatisticalTrendsAttributes::StatisticTypeEnum(ival));
    else
    {
        fprintf(stderr, "An invalid statisticType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Sum, Mean, Variance, StandardDeviation, Slope, "
                        "Residuals.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetStatisticType(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStatisticType()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetTrendAxis(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the trendAxis in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTrendAxis(StatisticalTrendsAttributes::TrendAxisEnum(ival));
    else
    {
        fprintf(stderr, "An invalid trendAxis value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Step, Time, Cycle.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetTrendAxis(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTrendAxis()));
    return retval;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_SetVariableSource(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the variableSource in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetVariableSource(StatisticalTrendsAttributes::VariableSourceEnum(ival));
    else
    {
        fprintf(stderr, "An invalid variableSource value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Default, OperatorExpression.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StatisticalTrendsAttributes_GetVariableSource(PyObject *self, PyObject *args)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVariableSource()));
    return retval;
}



PyMethodDef PyStatisticalTrendsAttributes_methods[STATISTICALTRENDSATTRIBUTES_NMETH] = {
    {"Notify", StatisticalTrendsAttributes_Notify, METH_VARARGS},
    {"SetStartIndex", StatisticalTrendsAttributes_SetStartIndex, METH_VARARGS},
    {"GetStartIndex", StatisticalTrendsAttributes_GetStartIndex, METH_VARARGS},
    {"SetStopIndex", StatisticalTrendsAttributes_SetStopIndex, METH_VARARGS},
    {"GetStopIndex", StatisticalTrendsAttributes_GetStopIndex, METH_VARARGS},
    {"SetStride", StatisticalTrendsAttributes_SetStride, METH_VARARGS},
    {"GetStride", StatisticalTrendsAttributes_GetStride, METH_VARARGS},
    {"SetStartTrendType", StatisticalTrendsAttributes_SetStartTrendType, METH_VARARGS},
    {"GetStartTrendType", StatisticalTrendsAttributes_GetStartTrendType, METH_VARARGS},
    {"SetStopTrendType", StatisticalTrendsAttributes_SetStopTrendType, METH_VARARGS},
    {"GetStopTrendType", StatisticalTrendsAttributes_GetStopTrendType, METH_VARARGS},
    {"SetStatisticType", StatisticalTrendsAttributes_SetStatisticType, METH_VARARGS},
    {"GetStatisticType", StatisticalTrendsAttributes_GetStatisticType, METH_VARARGS},
    {"SetTrendAxis", StatisticalTrendsAttributes_SetTrendAxis, METH_VARARGS},
    {"GetTrendAxis", StatisticalTrendsAttributes_GetTrendAxis, METH_VARARGS},
    {"SetVariableSource", StatisticalTrendsAttributes_SetVariableSource, METH_VARARGS},
    {"GetVariableSource", StatisticalTrendsAttributes_GetVariableSource, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
StatisticalTrendsAttributes_dealloc(PyObject *v)
{
   StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
StatisticalTrendsAttributes_compare(PyObject *v, PyObject *w)
{
    StatisticalTrendsAttributes *a = ((StatisticalTrendsAttributesObject *)v)->data;
    StatisticalTrendsAttributes *b = ((StatisticalTrendsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyStatisticalTrendsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "startIndex") == 0)
        return StatisticalTrendsAttributes_GetStartIndex(self, NULL);
    if(strcmp(name, "stopIndex") == 0)
        return StatisticalTrendsAttributes_GetStopIndex(self, NULL);
    if(strcmp(name, "stride") == 0)
        return StatisticalTrendsAttributes_GetStride(self, NULL);
    if(strcmp(name, "startTrendType") == 0)
        return StatisticalTrendsAttributes_GetStartTrendType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Absolute));
    if(strcmp(name, "Relative") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Relative));

    if(strcmp(name, "stopTrendType") == 0)
        return StatisticalTrendsAttributes_GetStopTrendType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Absolute));
    if(strcmp(name, "Relative") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Relative));

    if(strcmp(name, "statisticType") == 0)
        return StatisticalTrendsAttributes_GetStatisticType(self, NULL);
    if(strcmp(name, "Sum") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Sum));
    if(strcmp(name, "Mean") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Mean));
    if(strcmp(name, "Variance") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Variance));
    if(strcmp(name, "StandardDeviation") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::StandardDeviation));
    if(strcmp(name, "Slope") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Slope));
    if(strcmp(name, "Residuals") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Residuals));

    if(strcmp(name, "trendAxis") == 0)
        return StatisticalTrendsAttributes_GetTrendAxis(self, NULL);
    if(strcmp(name, "Step") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Step));
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Time));
    if(strcmp(name, "Cycle") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Cycle));

    if(strcmp(name, "variableSource") == 0)
        return StatisticalTrendsAttributes_GetVariableSource(self, NULL);
    if(strcmp(name, "Default") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::Default));
    if(strcmp(name, "OperatorExpression") == 0)
        return PyInt_FromLong(long(StatisticalTrendsAttributes::OperatorExpression));


    return Py_FindMethod(PyStatisticalTrendsAttributes_methods, self, name);
}

int
PyStatisticalTrendsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "startIndex") == 0)
        obj = StatisticalTrendsAttributes_SetStartIndex(self, tuple);
    else if(strcmp(name, "stopIndex") == 0)
        obj = StatisticalTrendsAttributes_SetStopIndex(self, tuple);
    else if(strcmp(name, "stride") == 0)
        obj = StatisticalTrendsAttributes_SetStride(self, tuple);
    else if(strcmp(name, "startTrendType") == 0)
        obj = StatisticalTrendsAttributes_SetStartTrendType(self, tuple);
    else if(strcmp(name, "stopTrendType") == 0)
        obj = StatisticalTrendsAttributes_SetStopTrendType(self, tuple);
    else if(strcmp(name, "statisticType") == 0)
        obj = StatisticalTrendsAttributes_SetStatisticType(self, tuple);
    else if(strcmp(name, "trendAxis") == 0)
        obj = StatisticalTrendsAttributes_SetTrendAxis(self, tuple);
    else if(strcmp(name, "variableSource") == 0)
        obj = StatisticalTrendsAttributes_SetVariableSource(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
StatisticalTrendsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)v;
    fprintf(fp, "%s", PyStatisticalTrendsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
StatisticalTrendsAttributes_str(PyObject *v)
{
    StatisticalTrendsAttributesObject *obj = (StatisticalTrendsAttributesObject *)v;
    return PyString_FromString(PyStatisticalTrendsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *StatisticalTrendsAttributes_Purpose = "This class contains attributes for the StatisticalTrends operator.";
#else
static char *StatisticalTrendsAttributes_Purpose = "This class contains attributes for the StatisticalTrends operator.";
#endif

//
// The type description structure
//
static PyTypeObject StatisticalTrendsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "StatisticalTrendsAttributes",                    // tp_name
    sizeof(StatisticalTrendsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)StatisticalTrendsAttributes_dealloc,  // tp_dealloc
    (printfunc)StatisticalTrendsAttributes_print,     // tp_print
    (getattrfunc)PyStatisticalTrendsAttributes_getattr, // tp_getattr
    (setattrfunc)PyStatisticalTrendsAttributes_setattr, // tp_setattr
    (cmpfunc)StatisticalTrendsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)StatisticalTrendsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    StatisticalTrendsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static StatisticalTrendsAttributes *defaultAtts = 0;
static StatisticalTrendsAttributes *currentAtts = 0;

static PyObject *
NewStatisticalTrendsAttributes(int useCurrent)
{
    StatisticalTrendsAttributesObject *newObject;
    newObject = PyObject_NEW(StatisticalTrendsAttributesObject, &StatisticalTrendsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new StatisticalTrendsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new StatisticalTrendsAttributes(*defaultAtts);
    else
        newObject->data = new StatisticalTrendsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapStatisticalTrendsAttributes(const StatisticalTrendsAttributes *attr)
{
    StatisticalTrendsAttributesObject *newObject;
    newObject = PyObject_NEW(StatisticalTrendsAttributesObject, &StatisticalTrendsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (StatisticalTrendsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
StatisticalTrendsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewStatisticalTrendsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef StatisticalTrendsAttributesMethods[] = {
    {"StatisticalTrendsAttributes", StatisticalTrendsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *StatisticalTrendsAttributesObserver = 0;

std::string
PyStatisticalTrendsAttributes_GetLogString()
{
    std::string s("StatisticalTrendsAtts = StatisticalTrendsAttributes()\n");
    if(currentAtts != 0)
        s += PyStatisticalTrendsAttributes_ToString(currentAtts, "StatisticalTrendsAtts.");
    return s;
}

static void
PyStatisticalTrendsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("StatisticalTrendsAtts = StatisticalTrendsAttributes()\n");
        s += PyStatisticalTrendsAttributes_ToString(currentAtts, "StatisticalTrendsAtts.");
        cb(s);
    }
}

void
PyStatisticalTrendsAttributes_StartUp(StatisticalTrendsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyStatisticalTrendsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(StatisticalTrendsAttributesObserver == 0)
    {
        StatisticalTrendsAttributesObserver = new ObserverToCallback(subj,
            PyStatisticalTrendsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyStatisticalTrendsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete StatisticalTrendsAttributesObserver;
    StatisticalTrendsAttributesObserver = 0;
}

PyMethodDef *
PyStatisticalTrendsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return StatisticalTrendsAttributesMethods;
}

bool
PyStatisticalTrendsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &StatisticalTrendsAttributesType);
}

StatisticalTrendsAttributes *
PyStatisticalTrendsAttributes_FromPyObject(PyObject *obj)
{
    StatisticalTrendsAttributesObject *obj2 = (StatisticalTrendsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyStatisticalTrendsAttributes_New()
{
    return NewStatisticalTrendsAttributes(0);
}

PyObject *
PyStatisticalTrendsAttributes_Wrap(const StatisticalTrendsAttributes *attr)
{
    return WrapStatisticalTrendsAttributes(attr);
}

void
PyStatisticalTrendsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    StatisticalTrendsAttributesObject *obj2 = (StatisticalTrendsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyStatisticalTrendsAttributes_SetDefaults(const StatisticalTrendsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new StatisticalTrendsAttributes(*atts);
}

