// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  StaggerScriptingPluginInfo.C
// ************************************************************************* //
#include <PyStaggerAttributes.h>
#include <StaggerPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Stagger,Scripting)

// ****************************************************************************
// Method: StaggerScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
StaggerScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyStaggerAttributes_StartUp((StaggerAttributes *)subj, data);
}

// ****************************************************************************
// Method: StaggerScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
StaggerScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyStaggerAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: StaggerScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Stagger plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StaggerScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyStaggerAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: StaggerScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
StaggerScriptingPluginInfo::GetLogString()
{
    std::string s(PyStaggerAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: StaggerScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
StaggerScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyStaggerAttributes_SetDefaults((const StaggerAttributes *)atts);
}
