// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: StaggerAttributes
//
// Purpose:
//    This class contains attributes for the stagger operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class StaggerAttributes extends AttributeSubject implements Plugin
{
    private static int StaggerAttributes_numAdditionalAtts = 3;

    public StaggerAttributes()
    {
        super(StaggerAttributes_numAdditionalAtts);

        offsetX = 0;
        offsetY = 0;
        offsetZ = 0;
    }

    public StaggerAttributes(int nMoreFields)
    {
        super(StaggerAttributes_numAdditionalAtts + nMoreFields);

        offsetX = 0;
        offsetY = 0;
        offsetZ = 0;
    }

    public StaggerAttributes(StaggerAttributes obj)
    {
        super(obj);

        offsetX = obj.offsetX;
        offsetY = obj.offsetY;
        offsetZ = obj.offsetZ;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return StaggerAttributes_numAdditionalAtts;
    }

    public boolean equals(StaggerAttributes obj)
    {
        // Create the return value
        return ((offsetX == obj.offsetX) &&
                (offsetY == obj.offsetY) &&
                (offsetZ == obj.offsetZ));
    }

    public String GetName() { return "Stagger"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetOffsetX(double offsetX_)
    {
        offsetX = offsetX_;
        Select(0);
    }

    public void SetOffsetY(double offsetY_)
    {
        offsetY = offsetY_;
        Select(1);
    }

    public void SetOffsetZ(double offsetZ_)
    {
        offsetZ = offsetZ_;
        Select(2);
    }

    // Property getting methods
    public double GetOffsetX() { return offsetX; }
    public double GetOffsetY() { return offsetY; }
    public double GetOffsetZ() { return offsetZ; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(offsetX);
        if(WriteSelect(1, buf))
            buf.WriteDouble(offsetY);
        if(WriteSelect(2, buf))
            buf.WriteDouble(offsetZ);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetOffsetX(buf.ReadDouble());
            break;
        case 1:
            SetOffsetY(buf.ReadDouble());
            break;
        case 2:
            SetOffsetZ(buf.ReadDouble());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + doubleToString("offsetX", offsetX, indent) + "\n";
        str = str + doubleToString("offsetY", offsetY, indent) + "\n";
        str = str + doubleToString("offsetZ", offsetZ, indent) + "\n";
        return str;
    }


    // Attributes
    private double offsetX;
    private double offsetY;
    private double offsetZ;
}

