// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef STAGGERATTRIBUTES_H
#define STAGGERATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: StaggerAttributes
//
// Purpose:
//    This class contains attributes for the stagger operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class StaggerAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    StaggerAttributes();
    StaggerAttributes(const StaggerAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    StaggerAttributes(private_tmfs_t tmfs);
    StaggerAttributes(const StaggerAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~StaggerAttributes();

    virtual StaggerAttributes& operator = (const StaggerAttributes &obj);
    virtual bool operator == (const StaggerAttributes &obj) const;
    virtual bool operator != (const StaggerAttributes &obj) const;
private:
    void Init();
    void Copy(const StaggerAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetOffsetX(double offsetX_);
    void SetOffsetY(double offsetY_);
    void SetOffsetZ(double offsetZ_);

    // Property getting methods
    double GetOffsetX() const;
    double GetOffsetY() const;
    double GetOffsetZ() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_offsetX = 0,
        ID_offsetY,
        ID_offsetZ,
        ID__LAST
    };

private:
    double offsetX;
    double offsetY;
    double offsetZ;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define STAGGERATTRIBUTES_TMFS "ddd"

#endif
