// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSTAGGERWINDOW_H
#define QVISSTAGGERWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class StaggerAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisStaggerWindow
//
// Purpose:
//    Defines QvisStaggerWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisStaggerWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisStaggerWindow(const int type,
                         StaggerAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisStaggerWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void offsetXProcessText();
    void offsetYProcessText();
    void offsetZProcessText();
  private:
    QLineEdit *offsetX;
    QLineEdit *offsetY;
    QLineEdit *offsetZ;
    QLabel *offsetXLabel;
    QLabel *offsetYLabel;
    QLabel *offsetZLabel;

    StaggerAttributes *atts;
};



#endif
