// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyStaggerAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyStaggerAttributes
//
// Purpose:
//   This class contains attributes for the stagger operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a StaggerAttributes.
//
struct StaggerAttributesObject
{
    PyObject_HEAD
    StaggerAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewStaggerAttributes(int);

std::string
PyStaggerAttributes_ToString(const StaggerAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%soffsetX = %g\n", prefix, atts->GetOffsetX());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%soffsetY = %g\n", prefix, atts->GetOffsetY());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%soffsetZ = %g\n", prefix, atts->GetOffsetZ());
    str += tmpStr;
    return str;
}

static PyObject *
StaggerAttributes_Notify(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StaggerAttributes_SetOffsetX(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the offsetX in the object.
    obj->data->SetOffsetX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StaggerAttributes_GetOffsetX(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOffsetX());
    return retval;
}

/*static*/ PyObject *
StaggerAttributes_SetOffsetY(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the offsetY in the object.
    obj->data->SetOffsetY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StaggerAttributes_GetOffsetY(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOffsetY());
    return retval;
}

/*static*/ PyObject *
StaggerAttributes_SetOffsetZ(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the offsetZ in the object.
    obj->data->SetOffsetZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StaggerAttributes_GetOffsetZ(PyObject *self, PyObject *args)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOffsetZ());
    return retval;
}



PyMethodDef PyStaggerAttributes_methods[STAGGERATTRIBUTES_NMETH] = {
    {"Notify", StaggerAttributes_Notify, METH_VARARGS},
    {"SetOffsetX", StaggerAttributes_SetOffsetX, METH_VARARGS},
    {"GetOffsetX", StaggerAttributes_GetOffsetX, METH_VARARGS},
    {"SetOffsetY", StaggerAttributes_SetOffsetY, METH_VARARGS},
    {"GetOffsetY", StaggerAttributes_GetOffsetY, METH_VARARGS},
    {"SetOffsetZ", StaggerAttributes_SetOffsetZ, METH_VARARGS},
    {"GetOffsetZ", StaggerAttributes_GetOffsetZ, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
StaggerAttributes_dealloc(PyObject *v)
{
   StaggerAttributesObject *obj = (StaggerAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
StaggerAttributes_compare(PyObject *v, PyObject *w)
{
    StaggerAttributes *a = ((StaggerAttributesObject *)v)->data;
    StaggerAttributes *b = ((StaggerAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyStaggerAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "offsetX") == 0)
        return StaggerAttributes_GetOffsetX(self, NULL);
    if(strcmp(name, "offsetY") == 0)
        return StaggerAttributes_GetOffsetY(self, NULL);
    if(strcmp(name, "offsetZ") == 0)
        return StaggerAttributes_GetOffsetZ(self, NULL);

    return Py_FindMethod(PyStaggerAttributes_methods, self, name);
}

int
PyStaggerAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "offsetX") == 0)
        obj = StaggerAttributes_SetOffsetX(self, tuple);
    else if(strcmp(name, "offsetY") == 0)
        obj = StaggerAttributes_SetOffsetY(self, tuple);
    else if(strcmp(name, "offsetZ") == 0)
        obj = StaggerAttributes_SetOffsetZ(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
StaggerAttributes_print(PyObject *v, FILE *fp, int flags)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)v;
    fprintf(fp, "%s", PyStaggerAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
StaggerAttributes_str(PyObject *v)
{
    StaggerAttributesObject *obj = (StaggerAttributesObject *)v;
    return PyString_FromString(PyStaggerAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *StaggerAttributes_Purpose = "This class contains attributes for the stagger operator.";
#else
static char *StaggerAttributes_Purpose = "This class contains attributes for the stagger operator.";
#endif

//
// The type description structure
//
static PyTypeObject StaggerAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "StaggerAttributes",                    // tp_name
    sizeof(StaggerAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)StaggerAttributes_dealloc,  // tp_dealloc
    (printfunc)StaggerAttributes_print,     // tp_print
    (getattrfunc)PyStaggerAttributes_getattr, // tp_getattr
    (setattrfunc)PyStaggerAttributes_setattr, // tp_setattr
    (cmpfunc)StaggerAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)StaggerAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    StaggerAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static StaggerAttributes *defaultAtts = 0;
static StaggerAttributes *currentAtts = 0;

static PyObject *
NewStaggerAttributes(int useCurrent)
{
    StaggerAttributesObject *newObject;
    newObject = PyObject_NEW(StaggerAttributesObject, &StaggerAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new StaggerAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new StaggerAttributes(*defaultAtts);
    else
        newObject->data = new StaggerAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapStaggerAttributes(const StaggerAttributes *attr)
{
    StaggerAttributesObject *newObject;
    newObject = PyObject_NEW(StaggerAttributesObject, &StaggerAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (StaggerAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
StaggerAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewStaggerAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef StaggerAttributesMethods[] = {
    {"StaggerAttributes", StaggerAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *StaggerAttributesObserver = 0;

std::string
PyStaggerAttributes_GetLogString()
{
    std::string s("StaggerAtts = StaggerAttributes()\n");
    if(currentAtts != 0)
        s += PyStaggerAttributes_ToString(currentAtts, "StaggerAtts.");
    return s;
}

static void
PyStaggerAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("StaggerAtts = StaggerAttributes()\n");
        s += PyStaggerAttributes_ToString(currentAtts, "StaggerAtts.");
        cb(s);
    }
}

void
PyStaggerAttributes_StartUp(StaggerAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyStaggerAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(StaggerAttributesObserver == 0)
    {
        StaggerAttributesObserver = new ObserverToCallback(subj,
            PyStaggerAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyStaggerAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete StaggerAttributesObserver;
    StaggerAttributesObserver = 0;
}

PyMethodDef *
PyStaggerAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return StaggerAttributesMethods;
}

bool
PyStaggerAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &StaggerAttributesType);
}

StaggerAttributes *
PyStaggerAttributes_FromPyObject(PyObject *obj)
{
    StaggerAttributesObject *obj2 = (StaggerAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyStaggerAttributes_New()
{
    return NewStaggerAttributes(0);
}

PyObject *
PyStaggerAttributes_Wrap(const StaggerAttributes *attr)
{
    return WrapStaggerAttributes(attr);
}

void
PyStaggerAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    StaggerAttributesObject *obj2 = (StaggerAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyStaggerAttributes_SetDefaults(const StaggerAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new StaggerAttributes(*atts);
}

