// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtSphereSliceFilter.h
// ************************************************************************* //

#ifndef AVT_SphereSlice_FILTER_H
#define AVT_SphereSlice_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <SphereSliceAttributes.h>

class vtkQuadric;


// ****************************************************************************
//  Class: avtSphereSliceFilter
//
//  Purpose:
//      A plugin operator for SphereSlice.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
//  Modifications:
//      Eric Brugger, Thu Aug 14 16:42:07 PDT 2014
//      Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtSphereSliceFilter : public avtPluginDataTreeIterator
{
  public:
                         avtSphereSliceFilter();
    virtual             ~avtSphereSliceFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtSphereSliceFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Slicing to a sphere"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    SphereSliceAttributes   atts;
    double                  origin[3];
    double                  radius;

    vtkQuadric             *quadric;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);

    virtual void            UpdateDataObjectInfo(void);
};


#endif
