// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SphereSliceScriptingPluginInfo.C
// ************************************************************************* //
#include <PySphereSliceAttributes.h>
#include <SphereSlicePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SphereSlice,Scripting)

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SphereSliceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySphereSliceAttributes_StartUp((SphereSliceAttributes *)subj, data);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SphereSliceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySphereSliceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is SphereSlice plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SphereSliceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySphereSliceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SphereSliceScriptingPluginInfo::GetLogString()
{
    std::string s(PySphereSliceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SphereSliceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySphereSliceAttributes_SetDefaults((const SphereSliceAttributes *)atts);
}
