// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SPHERESLICEATTRIBUTES_H
#define SPHERESLICEATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SphereSliceAttributes
//
// Purpose:
//    This class contains attributes for the spherical slice.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class SphereSliceAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SphereSliceAttributes();
    SphereSliceAttributes(const SphereSliceAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SphereSliceAttributes(private_tmfs_t tmfs);
    SphereSliceAttributes(const SphereSliceAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SphereSliceAttributes();

    virtual SphereSliceAttributes& operator = (const SphereSliceAttributes &obj);
    virtual bool operator == (const SphereSliceAttributes &obj) const;
    virtual bool operator != (const SphereSliceAttributes &obj) const;
private:
    void Init();
    void Copy(const SphereSliceAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectOrigin();

    // Property setting methods
    void SetOrigin(const double *origin_);
    void SetRadius(double radius_);

    // Property getting methods
    const double *GetOrigin() const;
          double *GetOrigin();
    double       GetRadius() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_origin = 0,
        ID_radius,
        ID__LAST
    };

private:
    double origin[3];
    double radius;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SPHERESLICEATTRIBUTES_TMFS "Dd"

#endif
