// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PySphereSliceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PySphereSliceAttributes
//
// Purpose:
//   This class contains attributes for the spherical slice.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SphereSliceAttributes.
//
struct SphereSliceAttributesObject
{
    PyObject_HEAD
    SphereSliceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSphereSliceAttributes(int);

std::string
PySphereSliceAttributes_ToString(const SphereSliceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *origin = atts->GetOrigin();
        snprintf(tmpStr, 1000, "%sorigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", origin[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    return str;
}

static PyObject *
SphereSliceAttributes_Notify(PyObject *self, PyObject *args)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SphereSliceAttributes_SetOrigin(PyObject *self, PyObject *args)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)self;

    double *dvals = obj->data->GetOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the origin in the object as modified.
    obj->data->SelectOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SphereSliceAttributes_GetOrigin(PyObject *self, PyObject *args)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the origin.
    PyObject *retval = PyTuple_New(3);
    const double *origin = obj->data->GetOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(origin[i]));
    return retval;
}

/*static*/ PyObject *
SphereSliceAttributes_SetRadius(PyObject *self, PyObject *args)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SphereSliceAttributes_GetRadius(PyObject *self, PyObject *args)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}



PyMethodDef PySphereSliceAttributes_methods[SPHERESLICEATTRIBUTES_NMETH] = {
    {"Notify", SphereSliceAttributes_Notify, METH_VARARGS},
    {"SetOrigin", SphereSliceAttributes_SetOrigin, METH_VARARGS},
    {"GetOrigin", SphereSliceAttributes_GetOrigin, METH_VARARGS},
    {"SetRadius", SphereSliceAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", SphereSliceAttributes_GetRadius, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SphereSliceAttributes_dealloc(PyObject *v)
{
   SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SphereSliceAttributes_compare(PyObject *v, PyObject *w)
{
    SphereSliceAttributes *a = ((SphereSliceAttributesObject *)v)->data;
    SphereSliceAttributes *b = ((SphereSliceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySphereSliceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "origin") == 0)
        return SphereSliceAttributes_GetOrigin(self, NULL);
    if(strcmp(name, "radius") == 0)
        return SphereSliceAttributes_GetRadius(self, NULL);

    return Py_FindMethod(PySphereSliceAttributes_methods, self, name);
}

int
PySphereSliceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "origin") == 0)
        obj = SphereSliceAttributes_SetOrigin(self, tuple);
    else if(strcmp(name, "radius") == 0)
        obj = SphereSliceAttributes_SetRadius(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SphereSliceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)v;
    fprintf(fp, "%s", PySphereSliceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SphereSliceAttributes_str(PyObject *v)
{
    SphereSliceAttributesObject *obj = (SphereSliceAttributesObject *)v;
    return PyString_FromString(PySphereSliceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SphereSliceAttributes_Purpose = "This class contains attributes for the spherical slice.";
#else
static char *SphereSliceAttributes_Purpose = "This class contains attributes for the spherical slice.";
#endif

//
// The type description structure
//
static PyTypeObject SphereSliceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SphereSliceAttributes",                    // tp_name
    sizeof(SphereSliceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SphereSliceAttributes_dealloc,  // tp_dealloc
    (printfunc)SphereSliceAttributes_print,     // tp_print
    (getattrfunc)PySphereSliceAttributes_getattr, // tp_getattr
    (setattrfunc)PySphereSliceAttributes_setattr, // tp_setattr
    (cmpfunc)SphereSliceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SphereSliceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SphereSliceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SphereSliceAttributes *defaultAtts = 0;
static SphereSliceAttributes *currentAtts = 0;

static PyObject *
NewSphereSliceAttributes(int useCurrent)
{
    SphereSliceAttributesObject *newObject;
    newObject = PyObject_NEW(SphereSliceAttributesObject, &SphereSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SphereSliceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SphereSliceAttributes(*defaultAtts);
    else
        newObject->data = new SphereSliceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSphereSliceAttributes(const SphereSliceAttributes *attr)
{
    SphereSliceAttributesObject *newObject;
    newObject = PyObject_NEW(SphereSliceAttributesObject, &SphereSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SphereSliceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SphereSliceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSphereSliceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SphereSliceAttributesMethods[] = {
    {"SphereSliceAttributes", SphereSliceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SphereSliceAttributesObserver = 0;

std::string
PySphereSliceAttributes_GetLogString()
{
    std::string s("SphereSliceAtts = SphereSliceAttributes()\n");
    if(currentAtts != 0)
        s += PySphereSliceAttributes_ToString(currentAtts, "SphereSliceAtts.");
    return s;
}

static void
PySphereSliceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SphereSliceAtts = SphereSliceAttributes()\n");
        s += PySphereSliceAttributes_ToString(currentAtts, "SphereSliceAtts.");
        cb(s);
    }
}

void
PySphereSliceAttributes_StartUp(SphereSliceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySphereSliceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SphereSliceAttributesObserver == 0)
    {
        SphereSliceAttributesObserver = new ObserverToCallback(subj,
            PySphereSliceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySphereSliceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SphereSliceAttributesObserver;
    SphereSliceAttributesObserver = 0;
}

PyMethodDef *
PySphereSliceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SphereSliceAttributesMethods;
}

bool
PySphereSliceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SphereSliceAttributesType);
}

SphereSliceAttributes *
PySphereSliceAttributes_FromPyObject(PyObject *obj)
{
    SphereSliceAttributesObject *obj2 = (SphereSliceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySphereSliceAttributes_New()
{
    return NewSphereSliceAttributes(0);
}

PyObject *
PySphereSliceAttributes_Wrap(const SphereSliceAttributes *attr)
{
    return WrapSphereSliceAttributes(attr);
}

void
PySphereSliceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SphereSliceAttributesObject *obj2 = (SphereSliceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySphereSliceAttributes_SetDefaults(const SphereSliceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SphereSliceAttributes(*atts);
}

