// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SmoothScriptingPluginInfo.C
// ************************************************************************* //
#include <PySmoothOperatorAttributes.h>
#include <SmoothPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Smooth,Scripting)

// ****************************************************************************
// Method: SmoothScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SmoothScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySmoothOperatorAttributes_StartUp((SmoothOperatorAttributes *)subj, data);
}

// ****************************************************************************
// Method: SmoothScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SmoothScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySmoothOperatorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SmoothScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Smooth plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SmoothScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySmoothOperatorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SmoothScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SmoothScriptingPluginInfo::GetLogString()
{
    std::string s(PySmoothOperatorAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SmoothScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SmoothScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySmoothOperatorAttributes_SetDefaults((const SmoothOperatorAttributes *)atts);
}
