// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SmoothPluginInfo.h
// ****************************************************************************

#ifndef SMOOTH_PLUGIN_INFO_H
#define SMOOTH_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class SmoothOperatorAttributes;

// ****************************************************************************
//  Class: SmoothPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Smooth operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class SmoothGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class SmoothCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual SmoothGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class SmoothGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual SmoothCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class SmoothViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual SmoothCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static SmoothOperatorAttributes *defaultAtts;
    static SmoothOperatorAttributes *clientAtts;
};

class SmoothViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual SmoothViewerEnginePluginInfo
{
  public:
};

class SmoothEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual SmoothViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class SmoothScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual SmoothCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
